/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.tools.exec.mapping;

import com.dimajix.common.ExceptionUtils;
import com.dimajix.flowman.execution.Context;
import com.dimajix.flowman.execution.Execution;
import com.dimajix.flowman.execution.NoSuchMappingException;
import com.dimajix.flowman.execution.Session;
import com.dimajix.flowman.execution.Status;
import com.dimajix.flowman.fs.File;
import com.dimajix.flowman.model.Mapping;
import com.dimajix.flowman.model.MappingOutputIdentifier;
import com.dimajix.flowman.model.MappingOutputIdentifier$;
import com.dimajix.flowman.model.Project;
import com.dimajix.flowman.tools.exec.Command;
import com.dimajix.flowman.types.Field$;
import com.dimajix.flowman.types.SchemaWriter;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.MatchError;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\t\u0013\u0001}AQ\u0001\n\u0001\u0005\u0002\u0015Bq\u0001\u000b\u0001C\u0002\u0013%\u0011\u0006\u0003\u00043\u0001\u0001\u0006IA\u000b\u0005\bg\u0001\u0001\r\u0011\"\u00015\u0011\u001d\u0011\u0005\u00011A\u0005\u0002\rCaA\u0013\u0001!B\u0013)\u0004bB2\u0001\u0001\u0004%\t\u0001\u001a\u0005\bQ\u0002\u0001\r\u0011\"\u0001j\u0011\u0019Y\u0007\u0001)Q\u0005K\"91\u0003\u0001a\u0001\n\u0003!\u0004b\u0002;\u0001\u0001\u0004%\t!\u001e\u0005\u0007o\u0002\u0001\u000b\u0015B\u001b\t\u0011\u0005\u001d\u0001\u00011A\u0005\u0002QB\u0011\"!\u0003\u0001\u0001\u0004%\t!a\u0003\t\u000f\u0005=\u0001\u0001)Q\u0005k!9\u0011Q\u0004\u0001\u0005B\u0005}!aE#ya>\u0014HoU2iK6\f7i\\7nC:$'BA\n\u0015\u0003\u001di\u0017\r\u001d9j]\u001eT!!\u0006\f\u0002\t\u0015DXm\u0019\u0006\u0003/a\tQ\u0001^8pYNT!!\u0007\u000e\u0002\u000f\u0019dwn^7b]*\u00111\u0004H\u0001\bI&l\u0017M[5y\u0015\u0005i\u0012aA2p[\u000e\u00011C\u0001\u0001!!\t\t#%D\u0001\u0015\u0013\t\u0019CCA\u0004D_6l\u0017M\u001c3\u0002\rqJg.\u001b;?)\u00051\u0003CA\u0014\u0001\u001b\u0005\u0011\u0012A\u00027pO\u001e,'/F\u0001+!\tY\u0003'D\u0001-\u0015\tic&A\u0003tY\u001a$$NC\u00010\u0003\ry'oZ\u0005\u0003c1\u0012a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0007M>\u0014X.\u0019;\u0016\u0003U\u0002\"AN \u000f\u0005]j\u0004C\u0001\u001d<\u001b\u0005I$B\u0001\u001e\u001f\u0003\u0019a$o\\8u})\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\u00051\u0001K]3eK\u001aL!\u0001Q!\u0003\rM#(/\u001b8h\u0015\tq4(\u0001\u0006g_Jl\u0017\r^0%KF$\"\u0001\u0012%\u0011\u0005\u00153U\"A\u001e\n\u0005\u001d[$\u0001B+oSRDq!S\u0003\u0002\u0002\u0003\u0007Q'A\u0002yIE\nqAZ8s[\u0006$\b\u0005\u000b\u0007\u0007\u0019R+v\u000bW.]=~\u000b'\r\u0005\u0002N%6\taJ\u0003\u0002P!\u00061\u0011M]4ti)T!!\u0015\u0018\u0002\u000f-|\u0007n];lK&\u00111K\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0002\t9\fW.Z\u0011\u0002-\u0006\u0011QFZ\u0001\bC2L\u0017m]3tY\u0005I\u0016%\u0001.\u0002\u00115jcm\u001c:nCR\fQ!^:bO\u0016\f\u0013!X\u0001\u0015'B,7-\u001b4jKN\u0004C\u000f[3!M>\u0014X.\u0019;\u0002\u000f5,G/\u0019,be\u0006\n\u0001-\u0001\u0005=M>\u0014X.\u0019;?\u0003!\u0011X-];je\u0016$\u0017$\u0001\u0001\u0002\u0011U\u001cXm\u00159be.,\u0012!\u001a\t\u0003\u000b\u001aL!aZ\u001e\u0003\u000f\t{w\u000e\\3b]\u0006aQo]3Ta\u0006\u00148n\u0018\u0013fcR\u0011AI\u001b\u0005\b\u0013\"\t\t\u00111\u0001f\u0003%)8/Z*qCJ\\\u0007\u0005\u000b\u0005\n\u0019Rkwk\\.sC\u0005q\u0017AA\u0017tY\u0005\u0001\u0018%A9\u0002\u000f5j3\u000f]1sW\u0006\n1/\u0001\u0011vg\u0016\u00043\u000b]1sW\u0002\"x\u000e\t3fe&4X\r\t4j]\u0006d\u0007e]2iK6\f\u0017aC7baBLgnZ0%KF$\"\u0001\u0012<\t\u000f%[\u0011\u0011!a\u0001k\u0005AQ.\u00199qS:<\u0007\u0005K\u0007\rsnchL`1\u0002\u0002\u0005\r\u0011Q\u0001\t\u0003\u001bjL!a\u001f(\u0003\u0011\u0005\u0013x-^7f]R\f\u0013!`\u0001)gB,7-\u001b4jKN\u0004C\u000f[3![\u0006\u0004\b/\u001b8hAQ|\u0007e]1wK\u0002\"\b.\u001a\u0011tG\",W.Y\u0011\u0002\u007f\u0006IA(\\1qa&twMP\r\u0002\u0003\u0005)\u0011N\u001c3fqv\t\u0001!\u0001\u0005gS2,g.Y7f\u000311\u0017\u000e\\3oC6,w\fJ3r)\r!\u0015Q\u0002\u0005\b\u0013:\t\t\u00111\u00016\u0003%1\u0017\u000e\\3oC6,\u0007\u0005K\b\u0010sn\u000b\u0019BXA\fC\u0006\u0005\u00111AA\u000eC\t\t)\"A\u000fta\u0016\u001c\u0017NZ5fg\u0002\"\b.\u001a\u0011pkR\u0004X\u000f\u001e\u0011gS2,g.Y7fC\t\tI\"\u0001\u0006=M&dWM\\1nKzj\u0012!A\u0001\bKb,7-\u001e;f)!\t\t#!\f\u00028\u0005\u001d\u0003\u0003BA\u0012\u0003Si!!!\n\u000b\u0007\u0005\u001d\u0002$A\u0005fq\u0016\u001cW\u000f^5p]&!\u00111FA\u0013\u0005\u0019\u0019F/\u0019;vg\"9\u0011q\u0006\tA\u0002\u0005E\u0012aB:fgNLwN\u001c\t\u0005\u0003G\t\u0019$\u0003\u0003\u00026\u0005\u0015\"aB*fgNLwN\u001c\u0005\b\u0003s\u0001\u0002\u0019AA\u001e\u0003\u001d\u0001(o\u001c6fGR\u0004B!!\u0010\u0002D5\u0011\u0011q\b\u0006\u0004\u0003\u0003B\u0012!B7pI\u0016d\u0017\u0002BA#\u0003\u007f\u0011q\u0001\u0015:pU\u0016\u001cG\u000fC\u0004\u0002JA\u0001\r!a\u0013\u0002\u000f\r|g\u000e^3yiB!\u00111EA'\u0013\u0011\ty%!\n\u0003\u000f\r{g\u000e^3yi\u0002")
public class ExportSchemaCommand
extends Command {
    private final Logger logger = LoggerFactory.getLogger(ExportSchemaCommand.class);
    @Option(name="-f", aliases={"--format"}, usage="Specifies the format", metaVar="<format>", required=false)
    private String format = "spark";
    @Option(name="-s", aliases={"--spark"}, usage="use Spark to derive final schema")
    private boolean useSpark = false;
    @Argument(usage="specifies the mapping to save the schema", metaVar="<mapping>", required=true, index=0)
    private String mapping = "";
    @Argument(usage="specifies the output filename", metaVar="<filename>", required=true, index=1)
    private String filename = "";

    private Logger logger() {
        return this.logger;
    }

    public String format() {
        return this.format;
    }

    public void format_$eq(String x$1) {
        this.format = x$1;
    }

    public boolean useSpark() {
        return this.useSpark;
    }

    public void useSpark_$eq(boolean x$1) {
        this.useSpark = x$1;
    }

    public String mapping() {
        return this.mapping;
    }

    public void mapping_$eq(String x$1) {
        this.mapping = x$1;
    }

    public String filename() {
        return this.filename;
    }

    public void filename_$eq(String x$1) {
        this.filename = x$1;
    }

    @Override
    public Status execute(Session session, Project project, Context context) {
        this.logger().info(new StringBuilder(40).append("Exporting the schema of mapping '").append(this.mapping()).append("' to '").append(this.filename()).append("'").toString());
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq seq;
            MappingOutputIdentifier id = MappingOutputIdentifier$.MODULE$.apply(this.mapping());
            Mapping instance = context.getMapping(id.mapping(), context.getMapping$default$2());
            Execution executor = session.execution();
            if (this.useSpark()) {
                Dataset table = executor.instantiate(instance, id.output());
                seq = Field$.MODULE$.of(table.schema());
            } else {
                seq = executor.describe(instance, id.output()).fields();
            }
            Seq schema = seq;
            File file = context.fs().local(this.filename());
            new SchemaWriter(schema).format(this.format()).save(file);
        });
        if (try_ instanceof Success) {
            this.logger().info("Successfully saved schema");
            return Status.SUCCESS$.MODULE$;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable ex = failure.exception();
            if (ex instanceof NoSuchMappingException) {
                NoSuchMappingException noSuchMappingException = (NoSuchMappingException)ex;
                this.logger().error(new StringBuilder(25).append("Cannot resolve mapping '").append(noSuchMappingException.mapping()).append("'").toString());
                return Status.FAILED$.MODULE$;
            }
        }
        if (bl) {
            Throwable e = failure.exception();
            this.logger().error(new StringBuilder(56).append("Caught exception while save the schema of mapping '").append(this.mapping()).append("':\n  ").append(ExceptionUtils.reasons((Throwable)e)).toString());
            return Status.FAILED$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }
}

