/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.tools.exec.relation;

import com.dimajix.common.ExceptionUtils;
import com.dimajix.flowman.execution.Context;
import com.dimajix.flowman.execution.Session;
import com.dimajix.flowman.execution.Status;
import com.dimajix.flowman.fs.File;
import com.dimajix.flowman.model.Project;
import com.dimajix.flowman.model.Relation;
import com.dimajix.flowman.model.Schema;
import com.dimajix.flowman.model.package;
import com.dimajix.flowman.tools.exec.Command;
import com.dimajix.flowman.types.SchemaWriter;
import java.io.Serializable;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001\u0002\b\u0010\u0001qAQ!\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013%a\u0005\u0003\u00040\u0001\u0001\u0006Ia\n\u0005\ba\u0001\u0001\r\u0011\"\u00012\u0011\u001dy\u0004\u00011A\u0005\u0002\u0001Caa\u0012\u0001!B\u0013\u0011\u0004b\u0002\t\u0001\u0001\u0004%\t!\r\u0005\bA\u0002\u0001\r\u0011\"\u0001b\u0011\u0019\u0019\u0007\u0001)Q\u0005e!9Q\u000e\u0001a\u0001\n\u0003\t\u0004b\u00028\u0001\u0001\u0004%\ta\u001c\u0005\u0007c\u0002\u0001\u000b\u0015\u0002\u001a\t\u000b]\u0004A\u0011\t=\u0003'\u0015C\bo\u001c:u'\u000eDW-\\1D_6l\u0017M\u001c3\u000b\u0005A\t\u0012\u0001\u0003:fY\u0006$\u0018n\u001c8\u000b\u0005I\u0019\u0012\u0001B3yK\u000eT!\u0001F\u000b\u0002\u000bQ|w\u000e\\:\u000b\u0005Y9\u0012a\u00024m_^l\u0017M\u001c\u0006\u00031e\tq\u0001Z5nC*L\u0007PC\u0001\u001b\u0003\r\u0019w.\\\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001f?5\t\u0011#\u0003\u0002!#\t91i\\7nC:$\u0017A\u0002\u001fj]&$h\bF\u0001$!\t!\u0003!D\u0001\u0010\u0003\u0019awnZ4feV\tq\u0005\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u0005)1\u000f\u001c45U*\tA&A\u0002pe\u001eL!AL\u0015\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\naAZ8s[\u0006$X#\u0001\u001a\u0011\u0005MbdB\u0001\u001b;!\t)\u0004(D\u00017\u0015\t94$\u0001\u0004=e>|GO\u0010\u0006\u0002s\u0005)1oY1mC&\u00111\bO\u0001\u0007!J,G-\u001a4\n\u0005ur$AB*ue&twM\u0003\u0002<q\u0005Qam\u001c:nCR|F%Z9\u0015\u0005\u0005+\u0005C\u0001\"D\u001b\u0005A\u0014B\u0001#9\u0005\u0011)f.\u001b;\t\u000f\u0019+\u0011\u0011!a\u0001e\u0005\u0019\u0001\u0010J\u0019\u0002\u000f\u0019|'/\\1uA!ba!S)S)VC\u0016l\u0017/_?B\u0011!jT\u0007\u0002\u0017*\u0011A*T\u0001\u0007CJ<7\u000f\u000e6\u000b\u00059[\u0013aB6pQN,8.Z\u0005\u0003!.\u0013aa\u00149uS>t\u0017\u0001\u00028b[\u0016\f\u0013aU\u0001\u0003[\u0019\fq!\u00197jCN,7\u000fL\u0001WC\u00059\u0016\u0001C\u0017.M>\u0014X.\u0019;\u0002\u000bU\u001c\u0018mZ3\"\u0003i\u000bAc\u00159fG&4\u0017.Z:!i\",\u0007EZ8s[\u0006$\u0018aB7fi\u00064\u0016M]\u0011\u0002;\u0006AAHZ8s[\u0006$h(\u0001\u0005sKF,\u0018N]3e3\u0005\u0001\u0011\u0001\u0004:fY\u0006$\u0018n\u001c8`I\u0015\fHCA!c\u0011\u001d1\u0005\"!AA\u0002I\n\u0011B]3mCRLwN\u001c\u0011)\u0011%)\u0007\f[.k=2\u0004\"A\u00134\n\u0005\u001d\\%\u0001C!sOVlWM\u001c;\"\u0003%\f\u0011f\u001d9fG&4\u0017.Z:!i\",\u0007E]3mCRLwN\u001c\u0011u_\u0002\u001a\u0018M^3!i\",\u0007e]2iK6\f\u0017%A6\u0002\u0015q\u0012X\r\\1uS>tg(G\u0001\u0002\u0003!1\u0017\u000e\\3oC6,\u0017\u0001\u00044jY\u0016t\u0017-\\3`I\u0015\fHCA!q\u0011\u001d15\"!AA\u0002I\n\u0011BZ5mK:\fW.\u001a\u0011)\u00111)\u0007l].v=2\f\u0013\u0001^\u0001\u001egB,7-\u001b4jKN\u0004C\u000f[3!_V$\b/\u001e;!M&dWM\\1nK\u0006\na/\u0001\u0006=M&dWM\\1nKz\nq!\u001a=fGV$X\r\u0006\u0004z\u007f\u0006%\u0011\u0011\u0004\t\u0003uvl\u0011a\u001f\u0006\u0003yV\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005y\\(AB*uCR,8\u000fC\u0004\u0002\u00025\u0001\r!a\u0001\u0002\u000fM,7o]5p]B\u0019!0!\u0002\n\u0007\u0005\u001d1PA\u0004TKN\u001c\u0018n\u001c8\t\u000f\u0005-Q\u00021\u0001\u0002\u000e\u00059\u0001O]8kK\u000e$\b\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005MQ#A\u0003n_\u0012,G.\u0003\u0003\u0002\u0018\u0005E!a\u0002)s_*,7\r\u001e\u0005\b\u00037i\u0001\u0019AA\u000f\u0003\u001d\u0019wN\u001c;fqR\u00042A_A\u0010\u0013\r\t\tc\u001f\u0002\b\u0007>tG/\u001a=u\u0001")
public class ExportSchemaCommand
extends Command {
    private final Logger logger = LoggerFactory.getLogger(ExportSchemaCommand.class);
    @Option(name="-f", aliases={"--format"}, usage="Specifies the format", metaVar="<format>", required=false)
    private String format = "spark";
    @Argument(usage="specifies the relation to save the schema", metaVar="<relation>", required=true)
    private String relation = "";
    @Argument(usage="specifies the output filename", metaVar="<filename>", required=true)
    private String filename = "";

    private Logger logger() {
        return this.logger;
    }

    public String format() {
        return this.format;
    }

    public void format_$eq(String x$1) {
        this.format = x$1;
    }

    public String relation() {
        return this.relation;
    }

    public void relation_$eq(String x$1) {
        this.relation = x$1;
    }

    public String filename() {
        return this.filename;
    }

    public void filename_$eq(String x$1) {
        this.filename = x$1;
    }

    @Override
    public Status execute(Session session, Project project, Context context) {
        this.logger().info(new StringBuilder(41).append("Exporting the schema of relation '").append(this.relation()).append("' to '").append(this.filename()).append("'").toString());
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Relation relation = context.getRelation(package.RelationIdentifier$.MODULE$.parse(this.relation()), context.getRelation$default$2());
            Schema schema = (Schema)relation.schema().get();
            File file = context.fs().local(this.filename());
            new SchemaWriter(schema.fields()).format(this.format()).save(file);
        });
        if (try_ instanceof Success) {
            this.logger().info("Successfully saved schema");
            return Status.SUCCESS$.MODULE$;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().error(new StringBuilder(57).append("Caught exception while save the schema of relation '").append(this.relation()).append("':\n  ").append(ExceptionUtils.reasons((Throwable)e)).toString());
            return Status.FAILED$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }
}

