/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.tools.exec.target;

import com.dimajix.common.ExceptionUtils;
import com.dimajix.flowman.execution.Context;
import com.dimajix.flowman.execution.Lifecycle$;
import com.dimajix.flowman.execution.NoSuchTargetException;
import com.dimajix.flowman.execution.Phase;
import com.dimajix.flowman.execution.Session;
import com.dimajix.flowman.execution.Status;
import com.dimajix.flowman.model.Project;
import com.dimajix.flowman.model.Target;
import com.dimajix.flowman.model.package;
import com.dimajix.flowman.tools.exec.Command;
import java.io.Serializable;
import org.kohsuke.args4j.Argument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.SetLike;
import scala.collection.immutable.Set$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0003\u0006\u0001/!)A\u0004\u0001C\u0001;!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0003B\u0002\u0016\u0001A\u0003%!\u0005C\u0004\f\u0001\u0001\u0007I\u0011A\u0016\t\u000fe\u0002\u0001\u0019!C\u0001u!1\u0011\t\u0001Q!\n1BQa\u0015\u0001\u0005BQCQ!\u001c\u0001\u0005\n9\u0014a\"\u00138ta\u0016\u001cGoQ8n[\u0006tGM\u0003\u0002\f\u0019\u00051A/\u0019:hKRT!!\u0004\b\u0002\t\u0015DXm\u0019\u0006\u0003\u001fA\tQ\u0001^8pYNT!!\u0005\n\u0002\u000f\u0019dwn^7b]*\u00111\u0003F\u0001\bI&l\u0017M[5y\u0015\u0005)\u0012aA2p[\u000e\u00011C\u0001\u0001\u0019!\tI\"$D\u0001\r\u0013\tYBBA\u0004D_6l\u0017M\u001c3\u0002\rqJg.\u001b;?)\u0005q\u0002CA\u0010\u0001\u001b\u0005Q\u0011A\u00027pO\u001e,'/F\u0001#!\t\u0019\u0003&D\u0001%\u0015\t)c%A\u0003tY\u001a$$NC\u0001(\u0003\ry'oZ\u0005\u0003S\u0011\u0012a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u000b\u0002YA\u0011QF\u000e\b\u0003]Q\u0002\"a\f\u001a\u000e\u0003AR!!\r\f\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0007\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U\u0012\u0014A\u0003;be\u001e,Go\u0018\u0013fcR\u00111h\u0010\t\u0003yuj\u0011AM\u0005\u0003}I\u0012A!\u00168ji\"9\u0001)BA\u0001\u0002\u0004a\u0013a\u0001=%c\u00059A/\u0019:hKR\u0004\u0003\u0006\u0003\u0004D\u00172ke\nU)\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015AB1sON$$N\u0003\u0002IM\u000591n\u001c5tk.,\u0017B\u0001&F\u0005!\t%oZ;nK:$\u0018\u0001\u0003:fcVL'/\u001a3\u001a\u0003\u0005\tQ!^:bO\u0016\f\u0013aT\u0001\u001cgB,7-\u001b4jKN\u0004C/\u0019:hKR\u0004Co\u001c\u0011j]N\u0004Xm\u0019;\u0002\u000f5,G/\u0019,be\u0006\n!+\u0001\u0005=i\u0006\u0014x-\u001a;?\u0003\u001d)\u00070Z2vi\u0016$B!V.aQB\u0011a+W\u0007\u0002/*\u0011\u0001\fE\u0001\nKb,7-\u001e;j_:L!AW,\u0003\rM#\u0018\r^;t\u0011\u0015av\u00011\u0001^\u0003\u001d\u0019Xm]:j_:\u0004\"A\u00160\n\u0005};&aB*fgNLwN\u001c\u0005\u0006C\u001e\u0001\rAY\u0001\baJ|'.Z2u!\t\u0019g-D\u0001e\u0015\t)\u0007#A\u0003n_\u0012,G.\u0003\u0002hI\n9\u0001K]8kK\u000e$\b\"B5\b\u0001\u0004Q\u0017aB2p]R,\u0007\u0010\u001e\t\u0003-.L!\u0001\\,\u0003\u000f\r{g\u000e^3yi\u0006\t\u0002O]5oi\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:\u0015\u0007mz7\u000fC\u0003\f\u0011\u0001\u0007\u0001\u000f\u0005\u0002dc&\u0011!\u000f\u001a\u0002\u0007)\u0006\u0014x-\u001a;\t\u000bQD\u0001\u0019A;\u0002\u000bAD\u0017m]3\u0011\u0005Y3\u0018BA<X\u0005\u0015\u0001\u0006.Y:f\u0001")
public class InspectCommand
extends Command {
    private final Logger logger = LoggerFactory.getLogger(InspectCommand.class);
    @Argument(required=true, usage="specifies target to inspect", metaVar="<target>")
    private String target = "";

    private Logger logger() {
        return this.logger;
    }

    public String target() {
        return this.target;
    }

    public void target_$eq(String x$1) {
        this.target = x$1;
    }

    @Override
    public Status execute(Session session, Project project, Context context) {
        Status.FAILED$ fAILED$;
        try {
            Target target = context.getTarget(package.TargetIdentifier$.MODULE$.apply(this.target()));
            Predef$.MODULE$.println((Object)"Target:");
            Predef$.MODULE$.println((Object)new StringBuilder(10).append("    name: ").append(target.name()).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(10).append("    kind: ").append(target.kind()).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(12).append("    phases: ").append(target.phases().mkString(",")).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(12).append("    before: ").append(target.before().mkString(",")).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(11).append("    after: ").append(target.after().mkString(",")).toString());
            Lifecycle$.MODULE$.ALL().foreach((Function1 & Serializable & scala.Serializable)p -> {
                this.printDependencies(target, p);
                return BoxedUnit.UNIT;
            });
            fAILED$ = Status.SUCCESS$.MODULE$;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof NoSuchTargetException) {
                NoSuchTargetException noSuchTargetException = (NoSuchTargetException)throwable2;
                this.logger().error(new StringBuilder(24).append("Cannot resolve target '").append(noSuchTargetException.target()).append("'").toString());
                fAILED$ = Status.FAILED$.MODULE$;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logger().error(new StringBuilder(23).append("Error inspecting '").append(this.target()).append("':\n  ").append(ExceptionUtils.reasons((Throwable)e)).toString());
                fAILED$ = Status.FAILED$.MODULE$;
            }
            throw throwable;
        }
        return fAILED$;
    }

    private void printDependencies(Target target, Phase phase) {
        Predef$.MODULE$.println((Object)new StringBuilder(9).append("Phase '").append(phase).append("'").append((Object)(!target.phases().contains((Object)phase) ? " (inactive)" : "")).append(":").toString());
        Predef$.MODULE$.println((Object)"  Provides:");
        ((IterableLike)((SetLike)target.provides(phase).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.text(), Set$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)p -> {
            Predef$.MODULE$.println((Object)new StringBuilder(4).append("    ").append(p).toString());
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)"  Requires:");
        ((IterableLike)((SetLike)target.requires(phase).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.text(), Set$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)p -> {
            Predef$.MODULE$.println((Object)new StringBuilder(4).append("    ").append(p).toString());
            return BoxedUnit.UNIT;
        });
    }
}

