/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.tools.schema;

import com.dimajix.flowman.Tool;
import com.dimajix.flowman.spec.ModuleSpec;
import com.dimajix.flowman.spec.NamespaceSpec;
import com.dimajix.flowman.spec.ObjectMapper$;
import com.dimajix.flowman.spec.ProjectSpec;
import com.dimajix.flowman.spec.documentation.DocumenterSpec;
import com.dimajix.flowman.tools.schema.Arguments;
import com.dimajix.flowman.tools.schema.Driver$;
import com.dimajix.flowman.tools.schema.impl.MyJsonSchemaGenerator;
import com.dimajix.flowman.tools.schema.impl.MyJsonSchemaGenerator$;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0015<QAC\u0006\t\u0002Y1Q\u0001G\u0006\t\u0002eAQ\u0001I\u0001\u0005\u0002\u0005BQAI\u0001\u0005\u0002\rBQaN\u0001\u0005\u0002a2A\u0001G\u0006\u0001{!A\u0001&\u0002B\u0001B\u0003%!\tC\u0003!\u000b\u0011\u0005Q\tC\u00038\u000b\u0011\u0005\u0001\nC\u0003J\u000b\u0011%!*\u0001\u0004Ee&4XM\u001d\u0006\u0003\u00195\taa]2iK6\f'B\u0001\b\u0010\u0003\u0015!xn\u001c7t\u0015\t\u0001\u0012#A\u0004gY><X.\u00198\u000b\u0005I\u0019\u0012a\u00023j[\u0006T\u0017\u000e\u001f\u0006\u0002)\u0005\u00191m\\7\u0004\u0001A\u0011q#A\u0007\u0002\u0017\t1AI]5wKJ\u001c\"!\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta#\u0001\u0003nC&tGC\u0001\u0013(!\tYR%\u0003\u0002'9\t!QK\\5u\u0011\u0015A3\u00011\u0001*\u0003\u0011\t'oZ:\u0011\u0007mQC&\u0003\u0002,9\t)\u0011I\u001d:bsB\u0011Q\u0006\u000e\b\u0003]I\u0002\"a\f\u000f\u000e\u0003AR!!M\u000b\u0002\rq\u0012xn\u001c;?\u0013\t\u0019D$\u0001\u0004Qe\u0016$WMZ\u0005\u0003kY\u0012aa\u0015;sS:<'BA\u001a\u001d\u0003\r\u0011XO\u001c\u000b\u0003IeBQ\u0001\u000b\u0003A\u0002i\u00022aG\u001e-\u0013\taDD\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u001a\"!\u0002 \u0011\u0005}\u0002U\"A\b\n\u0005\u0005{!\u0001\u0002+p_2\u0004\"aF\"\n\u0005\u0011[!!C!sOVlWM\u001c;t)\t1u\t\u0005\u0002\u0018\u000b!)\u0001f\u0002a\u0001\u0005R\tA%\u0001\u0006tCZ,7k\u00195f[\u0006$B\u0001J&X3\")A*\u0003a\u0001\u001b\u00069!-Y:fI&\u0014\bC\u0001(V\u001b\u0005y%B\u0001)R\u0003\u00111\u0017\u000e\\3\u000b\u0005I\u001b\u0016a\u00018j_*\tA+\u0001\u0003kCZ\f\u0017B\u0001,P\u0005\u0011\u0001\u0016\r\u001e5\t\u000baK\u0001\u0019\u0001\u0017\u0002\t9\fW.\u001a\u0005\u00065&\u0001\raW\u0001\u000bUN|gnU2iK6\f\u0007C\u0001/d\u001b\u0005i&B\u00010`\u0003!!\u0017\r^1cS:$'B\u00011b\u0003\u001dQ\u0017mY6t_:T!AY\n\u0002\u0013\u0019\f7\u000f^3sq6d\u0017B\u00013^\u0005!Q5o\u001c8O_\u0012,\u0007")
public class Driver
extends Tool {
    private final Arguments args;

    public static void main(String[] stringArray) {
        Driver$.MODULE$.main(stringArray);
    }

    public void run() {
        Path baseDir = Paths.get(this.args.output(), new String[0]);
        Files.createDirectories(baseDir, new FileAttribute[0]);
        ObjectMapper objectMapper = ObjectMapper$.MODULE$.mapper();
        MyJsonSchemaGenerator jsonSchemaGenerator = new MyJsonSchemaGenerator(objectMapper, MyJsonSchemaGenerator$.MODULE$.$lessinit$greater$default$2());
        JsonNode moduleSchema = jsonSchemaGenerator.generateJsonSchema(ModuleSpec.class);
        ((ObjectNode)moduleSchema.get("definitions").get("Field")).replace("required", (JsonNode)JsonNodeFactory.instance.arrayNode().add("name"));
        this.saveSchema(baseDir, "module.json", moduleSchema);
        JsonNode namespaceSchema = jsonSchemaGenerator.generateJsonSchema(NamespaceSpec.class);
        this.saveSchema(baseDir, "namespace.json", namespaceSchema);
        JsonNode projectSchema = jsonSchemaGenerator.generateJsonSchema(ProjectSpec.class);
        this.saveSchema(baseDir, "project.json", projectSchema);
        JsonNode documenterSchema = jsonSchemaGenerator.generateJsonSchema(DocumenterSpec.class);
        this.saveSchema(baseDir, "documentation.json", documenterSchema);
    }

    private void saveSchema(Path basedir, String name, JsonNode jsonSchema) {
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        ObjectWriter writer = mapper.writer().withDefaultPrettyPrinter();
        String schema = writer.writeValueAsString((Object)jsonSchema);
        File file = new File(basedir.toFile(), name);
        Predef$.MODULE$.println((Object)new StringBuilder(37).append("Generating Flowman YAML schema '").append(file.toString()).append("'...'").toString());
        FileOutputStream output = new FileOutputStream(file);
        ByteBuffer bytes = Charset.forName("UTF-8").encode(schema);
        output.write(bytes.array(), bytes.arrayOffset(), bytes.limit());
        output.close();
    }

    public Driver(Arguments args) {
        this.args = args;
    }
}

