/*
 * $Id: Filter.java 109 2007-03-24 14:55:03Z max $
 * 
 * Copyright (c) 2006-2007 Maximilian Antoni. All rights reserved.
 * 
 * This software is licensed as described in the file LICENSE.txt, which you
 * should have received as part of this distribution. The terms are also
 * available at http://www.maxantoni.de/projects/eva-properties/license.txt.
 */
package com.eva.properties;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;

/**
 * filters the content provied by a <code>{@link DataSource}</code> and
 * replaces all expressions matching <code>${key.path}</code> with the values
 * from a <code>{@link com.eva.properties.Properties}</code> object.
 * 
 * @author Max Antoni
 * @version $Revision: 109 $
 */
public class Filter {
    private MapProperties properties;
    
    /**
     * creates a new filter with the given properties.
     * 
     * @param inMap the properties providing the values to replace.
     */
    public Filter(Map inMap) {
        super();
        if(inMap instanceof MapProperties) {
            properties = (MapProperties) inMap;
        }
        else {
            properties = new MapProperties(inMap);
        }
    }
    
    /**
     * reads the content from the provided <code>DataSource</code>, replaces
     * all expressions matching <code>${key.path}</code> and returns a
     * <code>StringBuffer</code> containg the filtered contents.
     * 
     * @param inDataSource the content to be filtered.
     * @return the filtered content.
     * @throws IOException
     * @throws PropertiesException 
     */
    public StringBuffer filtered(DataSource inDataSource) throws IOException,
            PropertiesException {
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = new BufferedReader(inDataSource.getReader());
        String line = null;
        while((line = reader.readLine()) != null) {
            String replaced = Replacer.replace(line, new Context(properties));
            if(replaced == null) {
                Log.instance().log(Level.WARNING, "Cannot replace \"" + line
                        + "\".");
                replaced = line;
            }
            buffer.append(replaced);
            buffer.append('\n');
        }
        return buffer;
    }
    
}
