/*
 * $Id: PropertiesException.java 113 2007-03-24 17:33:58Z max $
 * 
 * Copyright (c) 2006-2007 Maximilian Antoni. All rights reserved.
 * 
 * This software is licensed as described in the file LICENSE.txt, which you
 * should have received as part of this distribution. The terms are also
 * available at http://www.maxantoni.de/projects/eva-properties/license.txt.
 */
package com.eva.properties;

/**
 * runtime exception for the properties package.
 * 
 * @author Max Antoni
 * @version $Revision: 113 $
 */
public class PropertiesException extends RuntimeException {
    private static final long serialVersionUID = 7667568429031733934L;

    /**
     * creates a new properties exception with the given message.
     * 
     * @param inMessage the message.
     */
    public PropertiesException(String inMessage) {
        super(inMessage);
    }
    
    /**
     * creates a new properties exception with the given cause.
     * 
     * @param inCause the cause.
     */
    public PropertiesException(Throwable inCause) {
        super(inCause);
    }

    /**
     * creates a new properties exception with the given message and cause.
     * 
     * @param inMessage the message.
     * @param inCause the cause.
     */
    public PropertiesException(String inMessage, Throwable inCause) {
        super(inMessage, inCause);
    }

}
