/*
 * $Id: PropertiesFactory.java 109 2007-03-24 14:55:03Z max $
 * 
 * Copyright (c) 2006-2007 Maximilian Antoni. All rights reserved.
 * 
 * This software is licensed as described in the file LICENSE.txt, which you
 * should have received as part of this distribution. The terms are also
 * available at http://www.maxantoni.de/projects/eva-properties/license.txt.
 */
package com.eva.properties;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * NOTE: this implementation is obsolete. You can now directly use the
 * constructors of <code>{@link MapProperties}</code> or
 * <code>{@link ListProperties}</code>.
 * </p>
 * <p>
 * provides static factory methods for creating property maps and property
 * lists.
 * </p>
 * 
 * @author Max Antoni
 * @version $Revision: 109 $
 * @deprecated
 */
public class PropertiesFactory {

    /**
     * is the name of the property that references the base path of the
     * properties file. This may be a file or a URL, depending on the mechanism
     * used to load the properties file.
     * 
     * @deprecated
     */
    public static final String DATASOURCE_BASE = "datasource-base";
    
    /**
     * creates an empty properties map.
     * 
     * @return the properties map.
     * @deprecated
     */
    public static Map createMap() {
        return new MapProperties();
    }
    
    /**
     * creates a copy of the given properties map.
     * 
     * @param inMap the properties map.
     * @return the copy of the properties map.
     * @throws IllegalArgumentException if the map was not a properties map.
     * @deprecated
     */
    public static Map copy(Map inMap) {
        if(inMap == null) {
            throw new NullPointerException();
        }
        if(inMap instanceof MapProperties) {
            Properties properties = (Properties) inMap;
            return (MapProperties) properties.copy(properties.getParent());
        }
        throw new IllegalArgumentException("Not a properties map.");
    }
    
    /**
     * creates a properties map with an initialization map. If the given map is
     * a properties instance, it will be used as the parent for the new
     * properties map. Otherwise each entry of the given map will be transfered
     * to the new properties map.
     * 
     * @param inMap the map for initialization.
     * @return the properties map.
     * @deprecated
     */
    public static Map createMap(Map inMap) {
        return new MapProperties(inMap);
    }

    /**
     * creates a properties map from the given data source.
     * 
     * @param inDataSource the data source.
     * @return the properties map.
     * @deprecated
     */
    public static Map createMap(DataSource inDataSource) {
        return new MapProperties(inDataSource);
    }
    
    /**
     * @param inPath
     * @return the map.
     * @throws IOException
     * @deprecated
     */
    public static Map createMap(String inPath) throws IOException {
        return new MapProperties(inPath);
    }
    
    /**
     * @param inFile
     * @return the map.
     * @throws IOException
     * @deprecated
     */
    public static Map createMap(File inFile) throws IOException {
        return new MapProperties(new DataSource(inFile));
    }
    
    /**
     * @param inStream
     * @return the map.
     * @deprecated
     */
    public static Map createMap(InputStream inStream) {
        return new MapProperties(inStream);
    }
    
    /**
     * @param inReader
     * @return the map.
     * @deprecated
     */
    public static Map createMap(Reader inReader) {
        return new MapProperties(inReader);
    }
    
    /**
     * @return the list.
     * @deprecated
     */
    public static List createList() {
        return new ListProperties();
    }
    
    /**
     * @param inList
     * @return the list.
     * @deprecated
     */
    public static List createList(List inList) {
        return new ListProperties(inList);
    }

    /**
     * @param inMap
     * @return the list.
     * @deprecated
     */
    public static List createList(Map inMap) {
        return new ListProperties(inMap);
    }
    
    /**
     * @param inDataSource
     * @return the list.
     * @deprecated
     */
    public static List createList(DataSource inDataSource) {
        return new ListProperties(inDataSource);
    }

    /**
     * @param inPath
     * @return the list.
     * @throws IOException
     * @deprecated
     */
    public static List createList(String inPath)
            throws IOException {
        return new ListProperties(inPath);
    }
    
    /**
     * @param inFile
     * @return the list
     * @throws FileNotFoundException
     * @deprecated
     */
    public static List createList(File inFile) throws FileNotFoundException {
        return new ListProperties(new DataSource(inFile));
    }
    
    /**
     * @param inStream
     * @return the list.
     * @deprecated
     */
    public static List createList(InputStream inStream) {
        return new ListProperties(inStream);
    }
    
    /**
     * @param inReader
     * @return the list.
     * @deprecated
     */
    public static List createList(Reader inReader) {
        return new ListProperties(inReader);
    }
    
    /**
     * @param inParameters
     * @return the list.
     * @deprecated
     */
    public static Map startParameters(String[] inParameters) {
        return new MapProperties(inParameters);
    }
    
    /**
     * Prevent instantiation.
     */
    private PropertiesFactory() {
        // Prevent instantiation.
    }

}
