/*
 * $Id: Reference.java 22 2007-02-12 21:57:00Z max $
 * 
 * Copyright (c) 2006-2007 Maximilian Antoni. All rights reserved.
 * 
 * This software is licensed as described in the file LICENSE.txt, which you
 * should have received as part of this distribution. The terms are also
 * available at http://www.maxantoni.de/projects/eva-properties/license.txt.
 */
package com.eva.properties;

/**
 * is a reference of the form <code>${house.room.chair.0.color}</code>.
 * 
 * @author Max Antoni
 * @version $Revision: 22 $
 */
public class Reference implements Replaceable {
    private String reference;

    /**
     * creates a reference with a reference string.
     * 
     * @param inReference the reference.
     */
    public Reference(String inReference) {
        super();
        if(inReference == null) {
            throw new NullPointerException("Reference cannot be null.");
        }
        if("".equals(inReference)) {
            throw new IllegalArgumentException("Reference cannot be empty.");
        }
        reference = inReference;
    }
    
    /*
     * @see com.eva.properties.Replaceable#copy(com.eva.properties.Properties)
     */
    public Replaceable copy(Properties inParent) {
        return new Reference(reference);
    }

    /* 
     * @see com.eva.properties.Replaceable#replace(com.eva.properties.Context)
     */
    public Object replace(Context inContext) throws PropertiesException {
        return inContext.lookup(reference);
    }

    /* 
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return "${" + reference + "}";
    }

    /*
     * @see com.eva.properties.Replaceable#toString(java.lang.StringBuffer,
     *      java.lang.String)
     */
    public void write(Writer inoutWriter) {
        inoutWriter.append("${");
        inoutWriter.append(reference);
        inoutWriter.append("}");
        inoutWriter.appendNewline();
    }

    /**
     * returns the reference string for this reference.
     * 
     * @return the reference string.
     */
    String getReference() {
        return reference;
    }
}
