/*
 * $Id: DataSourceTest.java 109 2007-03-24 14:55:03Z max $
 * 
 * Copyright (c) 2006-2007 Maximilian Antoni. All rights reserved.
 * 
 * This software is licensed as described in the file LICENSE.txt, which you
 * should have received as part of this distribution. The terms are also
 * available at http://www.maxantoni.de/projects/eva-properties/license.txt.
 */
package com.eva.properties;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;

import junit.framework.TestCase;

/**
 * @author Max Antoni
 * @version $Revision: 109 $
 */
public class DataSourceTest extends TestCase {

    /**
     * Test method for
     * {@link com.eva.properties.DataSource#DataSource(java.lang.String)}.
     * @throws IOException 
     */
    public void testDataSourceString() throws IOException {
        DataSource ds = new DataSource(
                "classpath://com/eva/properties/short.eva");
        assertNotNull(ds.getReader());
    }
    
    /**
     * Test method for {@link com.eva.properties.DataSource#getReader()}.
     * 
     * @throws IOException
     */
    public void testGetReader() throws IOException {
        Reader reader = new DataSource(
                "classpath://com/eva/properties/short.eva").getReader();
        assertTrue(reader.ready());
        char[] chars = new char[12];
        reader.read(chars);
        assertEquals("\"very short\"", new String(chars));
        assertFalse(reader.ready());
    }
    
    public void testFailClasspathStream() {
        try {
            new DataSource("classpath://unavailable-file.eva");
            fail("Exception expected!");
        }
        catch(FileNotFoundException e) {
            assertTrue(true);
        }
    }

    public void testDataSourceBase() throws IOException {
        Map map = new MapProperties(
                "classpath://com/eva/properties/datasource-base.eva");
        assertEquals(DataSourceTest.class.getResource("datasource-base.eva")
                .toExternalForm(), map.get("datasource-base")
                + "/datasource-base.eva");
        assertEquals("very short", ((List) map.get("short")).get(0));
    }
    
}