/*
 * $Id: InheritanceTest.java 109 2007-03-24 14:55:03Z max $
 * 
 * Copyright (c) 2006-2007 Maximilian Antoni. All rights reserved.
 * 
 * This software is licensed as described in the file LICENSE.txt, which you
 * should have received as part of this distribution. The terms are also
 * available at http://www.maxantoni.de/projects/eva-properties/license.txt.
 */
package com.eva.properties;

import java.io.IOException;
import java.util.Map;

import junit.framework.TestCase;

/**
 * @author Max Antoni
 * @version $Revision: 109 $
 */
public class InheritanceTest extends TestCase {

    public void testDotStart() throws IOException {
        Map properties = new MapProperties(
                "classpath://com/eva/properties/inheritance.eva");
        assertEquals("Father", properties.get("older.father.first-name"));
        assertEquals("Foo", properties.get("older.father.last-name"));
        assertEquals("Father Foo", properties.get("older.father.full-name"));
        assertEquals("Son", properties.get("son.first-name"));
        assertEquals("Foo", properties.get("son.last-name"));
        assertEquals("Son Foo", properties.get("son.full-name"));
        assertEquals("Granny Foo", properties.get("older.granny.full-name"));
    }
    
    public void testDeepGet() throws IOException {
        Map properties = new MapProperties(
                "classpath://com/eva/properties/inheritance.eva");
        assertEquals("b", properties.get("a.b.c.name"));
        assertEquals("bar", properties.get("a.b.c.bla"));
    }
    
    public void testDeepPut() throws IOException {
        Map properties = new MapProperties(
                "classpath://com/eva/properties/inheritance.eva");
        assertNull(properties.get("a.b.c.blubb"));
        properties.put("a.b.c.blubb", "Hiya");
        assertEquals("Hiya", properties.get("a.b.c.blubb"));
    }
    
    public void testDeepPutViaSuper() throws IOException {
        Map properties = new MapProperties(
                "classpath://com/eva/properties/inheritance.eva");
        assertEquals("Foo", properties.get("son.last-name"));
        properties.put("son.last-name", "Hiya");
        assertEquals("Hiya", properties.get("son.last-name"));
        assertEquals("Foo", properties.get("older.father.last-name"));
    }
    
    public void testInherited() throws IOException {
        Map properties = new MapProperties(
                "classpath://com/eva/properties/inheritance.eva");
        assertEquals("defaults-base/x", properties.get("inherited.x"));
        assertEquals("defaults-base/y", properties.get("inherited.y"));
    }

    public void testInheritedViaProxy() throws IOException {
        Map properties = new MapProperties(
                "classpath://com/eva/properties/inheritance_default.eva");
        assertEquals("defaults-base/x", properties.get("inherited.x"));
        assertEquals("defaults-base/y", properties.get("inherited.y"));
    }

    public void testInheritedOverride() throws IOException {
        Map properties = new MapProperties(
                "classpath://com/eva/properties/inheritance.eva");
        assertEquals("world", properties.get("inherited.hello"));
    }

    public void testInjection() throws IOException {
        Map properties = new MapProperties(
                "classpath://com/eva/properties/inheritance.eva");
        assertEquals("Huhu", properties.get("daughter.injected"));
    }
    
}
