/*
 * $Id: ProtocolTest.java 109 2007-03-24 14:55:03Z max $
 * 
 * Copyright (c) 2006-2007 Maximilian Antoni. All rights reserved.
 * 
 * This software is licensed as described in the file LICENSE.txt, which you
 * should have received as part of this distribution. The terms are also
 * available at http://www.maxantoni.de/projects/eva-properties/license.txt.
 */
package com.eva.properties;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

import junit.framework.TestCase;

/**
 * @author Max Antoni
 * @version $Revision: 109 $
 */
public class ProtocolTest extends TestCase {
    public static final String STATIC_FIELD = "Hello from static!";
    private Map properties;
    
    public ProtocolTest() throws IOException {
        super();
        properties = new MapProperties(
                "classpath://com/eva/properties/protocol.eva");
    }

    public void testUrl() throws MalformedURLException {
        assertEquals(new URL("http://www.maxantoni.de"), properties.get("url"));
    }
    
    public void testFile() {
        assertEquals(new File("/some/path"), properties.get("file"));
    }
    
    public void testString() {
        assertEquals("file://foo", properties.get("string"));
    }
    
    public void testClass() {
        assertEquals(ProtocolTest.class, properties.get("class"));
    }
    
    public void testStatic() {
        assertEquals(STATIC_FIELD, properties.get("static"));
    }
    
    public void testClassPath() throws FileNotFoundException {
        assertEquals(new DataSource(
                "classpath://com/eva/properties/protocol.eva"), properties
                .get("classpath"));
    }

    public void testDataSource() throws FileNotFoundException {
        assertEquals(new DataSource(
                "classpath://com/eva/properties/protocol.eva"), properties
                .get("datasource"));
    }

    public void testDelegateBase() throws FileNotFoundException {
        // special property added when loading Properties from a DataSource:
        Object object = new DataSource(
                "classpath://com/eva/properties/protocol.eva")
                .getDelegateBase();
        assertTrue(object instanceof URL);
        assertEquals(object, properties.get(Properties.DATASOURCE_BASE));
    }
}
