/*
 * $Id: ProxyTest.java 109 2007-03-24 14:55:03Z max $
 *
 * Copyright (c) 2006-2007 Maximilian Antoni. All rights reserved.
 * 
 * This software is licensed as described in the file LICENSE.txt, which you
 * should have received as part of this distribution. The terms are also
 * available at http://www.maxantoni.de/projects/eva-properties/license.txt.
 */
package com.eva.properties;

import java.io.IOException;
import java.io.StringReader;
import java.util.Map;

import junit.framework.TestCase;

/**
 * @author Max Antoni
 * @version $Revision: 109 $
 */
public class ProxyTest extends TestCase {

    public void testClassLoader() throws IOException {
        Map proxy = new MapProperties(getClass().getClassLoader(),
                "classpath://com/eva/properties/proxy.eva");
        Map simple = (Map) proxy.get("simple");
        assertNotNull(simple);
        ClassLoader classLoader = (ClassLoader) simple.get("classloader");
        assertNotNull(classLoader);
        assertSame(getClass().getClassLoader(), classLoader);
    }
    
    public void testNoProxyParent() {
        MapProperties withParent = new MapProperties(new StringReader(
                "proxy: &\"classpath://com/eva/properties/short.eva\""));
        Properties proxy = (Properties) withParent.get("proxy");
        Properties parent = proxy.getParent();
        assertSame(withParent, parent);
        Map withoutParent = new MapProperties(new StringReader(
                "proxy: &!\"classpath://com/eva/properties/short.eva\""));
        assertNull(((Properties) withoutParent.get("proxy")).getParent());
    }
    
}
