/*
 * $Id: RecursionTest.java 109 2007-03-24 14:55:03Z max $
 * 
 * Copyright (c) 2006-2007 Maximilian Antoni. All rights reserved.
 * 
 * This software is licensed as described in the file LICENSE.txt, which you
 * should have received as part of this distribution. The terms are also
 * available at http://www.maxantoni.de/projects/eva-properties/license.txt.
 */
package com.eva.properties;

import java.io.IOException;
import java.util.Map;

import junit.framework.TestCase;

/**
 * @author Max Antoni
 * @version $Revision: 109 $
 */
public class RecursionTest extends TestCase {

    public void testSimple() throws IOException {
        // Enable properties debugging for this:
        Properties.DEBUG = true;
        
        Map properties = new MapProperties(
                "classpath://com/eva/properties/recursion.eva");
        try {
            properties.get("foo");
            fail("PropertiesException expected.");
        }
        catch(PropertiesException e) {
            assertEquals("Cannot resolve \"foo\", Cannot replace ${bar}, "
                    + "Cannot replace ${foo}, Recursive references: "
                    + "foo > bar > foo", e.getMessage());
        }
        assertTrue(true);
    }

}
