/*
 * $Id: StringTest.java 109 2007-03-24 14:55:03Z max $
 *
 * Copyright (c) 2007 Maximilian Antoni. All rights reserved.
 * 
 * This software is licensed as described in the file LICENSE.txt, which you
 * should have received as part of this distribution. The terms are also
 * available at http://www.maxantoni.de/projects/eva-properties/license.txt.
 */
package com.eva.properties;

import java.util.Map;

import junit.framework.TestCase;

/**
 * @author max
 * @version $Revision: 109 $
 */
public class StringTest extends TestCase {
    private Map map;
    
    public StringTest() {
        super();
        map = new MapProperties(getClass().getResourceAsStream("string.eva"));
    }
    
    public void testEscaped() {
        assertEquals(": /\\, (){}[]%&\"'#?!*\t\n", map.get("escaped"));
    }
    
    public void testSimple() {
        assertEquals("simple", map.get("simple"));
    }
    
    public void testDash() {
        assertEquals("a-dash", map.get("dash"));
    }
    
}
