/*
 * $Id: LogTest.java 109 2007-03-24 14:55:03Z max $
 *
 * Copyright (c) 2007 Maximilian Antoni. All rights reserved.
 * 
 * This software is licensed as described in the file LICENSE.txt, which you
 * should have received as part of this distribution. The terms are also
 * available at http://www.maxantoni.de/projects/eva-properties/license.txt.
 */
package com.eva.test;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

import junit.framework.TestCase;

/**
 * @author max
 * @version $Revision: 109 $
 */
public class LogTest extends TestCase {
    
    public static class TestHandler extends Handler {
        private StringBuffer message = new StringBuffer();
        
        /*
         * @see java.util.logging.Handler#close()
         */
        public void close() throws SecurityException {
            // empty
        }
        /*
         * @see java.util.logging.Handler#flush()
         */
        public void flush() {
            // emtpy
        }
        /*
         * @see java.util.logging.Handler#publish(java.util.logging.LogRecord)
         */
        public void publish(LogRecord inoutRecord) {
            message.append(getFormatter().format(inoutRecord));
        }
        
        public String flushMessage() {
            String out = message.toString();
            message.setLength(0);
            return out;
        }
    }
        
    private TestHandler handler;
    
    public LogTest() {
        super();
        handler = (TestHandler) Log.INSTANCE.getHandlers()[0];
    }

    public void testHandlerSetup() {
        assertEquals("", handler.flushMessage());
        Log.INSTANCE.log(Level.WARNING, "Not in properties");
        assertTrue(handler.flushMessage().endsWith(
                Level.WARNING.getLocalizedName() + ": Not in properties\n"));
        assertEquals("", handler.flushMessage());
    }

    public void testLogPropertiesMessage() {
        Log.INSTANCE.log(Level.INFO, "hello");
        assertTrue(handler.flushMessage().endsWith(
                Level.INFO.getLocalizedName() + ": Hello from EvaLog!\n"));
    }
    
    public void testLogLowerLevel() {
        Log.INSTANCE.log(Level.CONFIG, "Ignored message");
        assertEquals("", handler.flushMessage());
    }

}
