/*
 * Decompiled with CFR 0.152.
 */
package com.eva.log;

import com.eva.properties.DataSource;
import com.eva.properties.MapProperties;
import com.eva.properties.PropertiesException;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EvaLog {
    private static final Logger DEFAULT_LOGGER;
    private static final MapProperties DEFAULT_PROPERTIES;
    private static final String LOG_CONFIG_FILENAME = "log.eva";

    public static Logger create(Class inClass) {
        return EvaLog.create(inClass, (String)null);
    }

    public static Logger create(Class inClass, String inBundle) {
        return EvaLog.create(inClass.getClassLoader(), inClass.getPackage().getName(), inBundle);
    }

    public static Logger create(String inPackage) {
        return EvaLog.create(null, inPackage, (String)null);
    }

    public static Logger create(String inPackage, String inBundle) {
        return EvaLog.create(null, inPackage, inBundle);
    }

    private static Logger create(ClassLoader inClassLoader, String inPackage, String inBundle) {
        MapProperties properties = (MapProperties)DEFAULT_PROPERTIES.get(inPackage.replace('.', '-'));
        if (properties == null) {
            try {
                properties = new MapProperties(new DataSource(inClassLoader, "classpath://" + inPackage.replace('.', '/') + "/" + LOG_CONFIG_FILENAME));
            }
            catch (FileNotFoundException e) {
                DEFAULT_LOGGER.log(Level.CONFIG, "No logger configuration found for package \"" + inPackage + "\". Using defaults.");
            }
        }
        return EvaLog.create(inPackage, inBundle, properties);
    }

    public static Logger create(Package inPackage, Map inProperties) {
        return EvaLog.create(inPackage.getName(), null, inProperties);
    }

    public static Logger create(String inPackage, Map inProperties) {
        return EvaLog.create(inPackage, null, inProperties);
    }

    public static Logger create(String inPackage, String inBundle, Map inProperties) {
        Logger logger;
        String pkg;
        String bundle = inBundle;
        if (inProperties == null) {
            pkg = inPackage;
        } else {
            inProperties.put("super", DEFAULT_PROPERTIES);
            pkg = (String)inProperties.get("package");
            if (pkg == null) {
                pkg = inPackage;
            }
            if (bundle == null) {
                bundle = (String)inProperties.get("bundle");
            }
        }
        if (bundle == null) {
            logger = Logger.getLogger(pkg);
            if (DEFAULT_LOGGER.isLoggable(Level.FINE)) {
                DEFAULT_LOGGER.log(Level.FINE, "Logger for package \"" + inPackage + "\" created without resource bundle.");
            }
        } else {
            logger = Logger.getLogger(pkg, pkg + "." + bundle);
            if (DEFAULT_LOGGER.isLoggable(Level.FINE)) {
                DEFAULT_LOGGER.log(Level.FINE, "Logger for package \"" + inPackage + "\" created with resource bundle \"" + bundle + "\".");
            }
        }
        if (logger.getParent() == DEFAULT_LOGGER) {
            return logger;
        }
        logger.setParent(DEFAULT_LOGGER);
        if (inProperties != null) {
            EvaLog.configure(logger, inProperties);
        }
        return logger;
    }

    public static Logger getDefault() {
        return DEFAULT_LOGGER;
    }

    private static void configure(Logger inoutLogger, Map inProperties) {
        Boolean useParentHandlers;
        Filter filter;
        Handler singleHandler;
        if (DEFAULT_LOGGER.isLoggable(Level.FINER)) {
            DEFAULT_LOGGER.finer("Configure logger \"" + inoutLogger.getName() + "\" with:");
            Map properties = inProperties instanceof MapProperties ? ((MapProperties)inProperties).getMap() : inProperties;
            String[] keys = new String[]{"handler", "handlers", "encoding", "level", "formatter", "filter", "useParentHandlers"};
            boolean valuesPresent = false;
            for (int i = 0; i < keys.length; ++i) {
                Object value = properties.get(keys[i]);
                if (value == null) continue;
                DEFAULT_LOGGER.finer("\t" + keys[i] + ": " + value);
                valuesPresent = true;
            }
            if (!valuesPresent) {
                DEFAULT_LOGGER.finer("\tNo properties found.");
            }
        }
        List handlers = (singleHandler = (Handler)inProperties.get("handler")) == null ? (List)inProperties.get("handlers") : Collections.singletonList(singleHandler);
        String encoding = (String)inProperties.get("encoding");
        String l = (String)inProperties.get("level");
        Level level = l == null ? null : Level.parse(l);
        Formatter formatter = (Formatter)inProperties.get("formatter");
        if (handlers != null) {
            Iterator i = handlers.iterator();
            while (i.hasNext()) {
                Handler handler = (Handler)i.next();
                if (encoding != null) {
                    try {
                        handler.setEncoding(encoding);
                    }
                    catch (SecurityException e) {
                        throw new RuntimeException(e);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (level != null) {
                    handler.setLevel(level);
                }
                if (formatter != null) {
                    handler.setFormatter(formatter);
                }
                inoutLogger.addHandler(handler);
            }
        }
        if (level != null) {
            inoutLogger.setLevel(level);
        }
        if ((filter = (Filter)inProperties.get("filter")) != null) {
            inoutLogger.setFilter(filter);
        }
        if ((useParentHandlers = (Boolean)inProperties.get("useParentHandlers")) != null) {
            inoutLogger.setUseParentHandlers(useParentHandlers);
        }
    }

    private static MapProperties loadDefaults() {
        return new MapProperties(EvaLog.class.getResourceAsStream(LOG_CONFIG_FILENAME));
    }

    private EvaLog() {
    }

    static {
        MapProperties properties;
        PropertiesException exception = null;
        try {
            properties = new MapProperties(new DataSource("classpath://log.eva"));
        }
        catch (PropertiesException e) {
            exception = e;
            properties = EvaLog.loadDefaults();
        }
        catch (FileNotFoundException e) {
            properties = EvaLog.loadDefaults();
        }
        DEFAULT_PROPERTIES = properties;
        DEFAULT_LOGGER = Logger.getLogger(EvaLog.class.getPackage().getName());
        EvaLog.configure(DEFAULT_LOGGER, DEFAULT_PROPERTIES);
        if (exception != null) {
            DEFAULT_LOGGER.log(Level.WARNING, "Custom log properties cannot be read. Using defaults.", exception);
        }
    }
}

