/*
 * Decompiled with CFR 0.152.
 */
package com.eva.properties;

import com.eva.properties.Log;
import com.eva.properties.PropertiesException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;

public class DataSource {
    private static final String CLASSPATH = "classpath://";
    private static final Pattern URL_PATTERN = Pattern.compile("^[a-z]{3,}\\:\\/\\/.*");
    private ClassLoader classLoader;
    private Delegate delegate;

    public DataSource(ClassLoader inClassLoader, String inPath) throws FileNotFoundException {
        if (inPath == null) {
            throw new NullPointerException("Path cannot be null.");
        }
        this.classLoader = inClassLoader;
        if (inPath.startsWith(CLASSPATH)) {
            this.initWithClassPath(inPath);
        } else if (inPath.startsWith("file://")) {
            File file = new File(inPath.substring(7).replace('/', File.separatorChar));
            if (!file.exists()) {
                throw new FileNotFoundException("File not found: " + file.getAbsolutePath());
            }
            this.delegate = new FileDelegate(file);
        } else if (URL_PATTERN.matcher(inPath).matches()) {
            try {
                this.delegate = new URLDelegate(new URL(inPath));
            }
            catch (MalformedURLException e) {
                throw new FileNotFoundException("Malformed URL: " + inPath);
            }
        } else {
            File file = new File(inPath.replace('/', File.separatorChar));
            if (!file.exists()) {
                throw new FileNotFoundException("File not found: " + file.getAbsolutePath());
            }
            this.delegate = new FileDelegate(file);
        }
    }

    public DataSource(File inFile) throws FileNotFoundException {
        if (inFile == null) {
            throw new NullPointerException();
        }
        if (!inFile.exists()) {
            throw new FileNotFoundException(inFile.getAbsolutePath());
        }
        this.delegate = new FileDelegate(inFile);
    }

    public DataSource(String inPath) throws FileNotFoundException {
        this(null, inPath);
    }

    public boolean equals(Object inObject) {
        if (this == inObject) {
            return true;
        }
        if (inObject == null || this.getClass() != inObject.getClass()) {
            return false;
        }
        return this.delegate.equals(((DataSource)inObject).delegate);
    }

    public Object getDelegateBase() {
        return this.delegate.getBase();
    }

    public Reader getReader() {
        return this.delegate.getReader();
    }

    public int hashCode() {
        return 31 + this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private void initWithClassPath(String inPath) throws FileNotFoundException {
        String classpathResource = inPath.substring(CLASSPATH.length());
        URL resource = this.classLoader == null ? Thread.currentThread().getContextClassLoader().getResource(classpathResource) : this.classLoader.getResource(classpathResource);
        if (resource == null) {
            throw new FileNotFoundException("Resource not found in classpath: " + classpathResource);
        }
        this.delegate = new URLDelegate(resource);
    }

    private static class URLDelegate
    implements Delegate {
        private URL url;

        URLDelegate(URL inUrl) {
            this.url = inUrl;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.url.equals(((URLDelegate)obj).url);
        }

        public Object getBase() {
            String base = this.url.getFile();
            base = base.substring(0, base.lastIndexOf(47));
            try {
                return new URL(this.url.getProtocol(), this.url.getHost(), this.url.getPort(), base);
            }
            catch (MalformedURLException e) {
                throw new PropertiesException(e);
            }
        }

        public Reader getReader() throws PropertiesException {
            try {
                return new InputStreamReader(this.url.openStream());
            }
            catch (IOException e) {
                throw new PropertiesException("Cannot open stream from URL: " + this.url.toString());
            }
        }

        public int hashCode() {
            return 31 + this.url.hashCode();
        }

        public String toString() {
            return "\"" + this.url.toString() + "\"";
        }
    }

    private static class FileDelegate
    implements Delegate {
        private File file;

        FileDelegate(File inFile) {
            this.file = inFile;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.file.equals(((FileDelegate)obj).file);
        }

        public Object getBase() {
            try {
                return new File(this.file.getParent()).getCanonicalFile();
            }
            catch (IOException e) {
                Log.instance().warning("Cannot resolve canonical form of \"" + this.file.getParent() + "\": " + e.getMessage());
                return new File(this.file.getParent());
            }
        }

        public Reader getReader() throws PropertiesException {
            try {
                return new FileReader(this.file);
            }
            catch (FileNotFoundException e) {
                throw new PropertiesException("File not found: " + this.file.getAbsolutePath());
            }
        }

        public int hashCode() {
            return 17 + 5 * this.file.hashCode();
        }

        public String toString() {
            return "\"file://" + this.file.getAbsolutePath() + "\"";
        }
    }

    private static interface Delegate {
        public Object getBase();

        public Reader getReader() throws PropertiesException;
    }
}

