/*
 * Decompiled with CFR 0.152.
 */
package com.eva.properties;

import com.eva.properties.Context;
import com.eva.properties.DataSource;
import com.eva.properties.ListProperties;
import com.eva.properties.Null;
import com.eva.properties.Properties;
import com.eva.properties.PropertiesException;
import com.eva.properties.PropertiesParser;
import com.eva.properties.Proxy;
import com.eva.properties.Reference;
import com.eva.properties.Replaceable;
import com.eva.properties.SystemProperties;
import com.eva.properties.Writer;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class MapProperties
extends Properties
implements Map {
    public static final String JOKER = "*";
    public static final String SUPER = "super";
    public static final String SYSTEM = "system";
    private Map map = new LinkedHashMap();

    public static Map copy(Map inMap) {
        if (inMap == null) {
            throw new NullPointerException();
        }
        if (inMap instanceof MapProperties) {
            Properties properties = (Properties)((Object)inMap);
            return (MapProperties)properties.copy(properties.getParent());
        }
        throw new IllegalArgumentException("Not a properties map.");
    }

    public MapProperties() {
    }

    public MapProperties(ClassLoader inClassLoader, String inPath) throws PropertiesException, FileNotFoundException {
        if (inClassLoader == null) {
            throw new NullPointerException("ClassLoader is null.");
        }
        if (inPath == null) {
            throw new NullPointerException("Path is null.");
        }
        PropertiesParser.readMap(this, new DataSource(inClassLoader, inPath));
    }

    public MapProperties(DataSource inDataSource) throws PropertiesException {
        if (inDataSource == null) {
            throw new NullPointerException("DataSource is null.");
        }
        PropertiesParser.readMap(this, inDataSource);
    }

    public MapProperties(InputStream inStream) throws PropertiesException {
        if (inStream == null) {
            throw new NullPointerException("Stream is null.");
        }
        PropertiesParser.readMap(this, new InputStreamReader(inStream));
    }

    public MapProperties(Map inMap) {
        if (inMap == null) {
            throw new NullPointerException("Map is null.");
        }
        if (inMap instanceof Properties) {
            this.setParent((Properties)((Object)inMap));
        } else {
            this.map.putAll(inMap);
        }
    }

    public MapProperties(Properties inParent) {
        super(inParent);
    }

    public MapProperties(Reader inReader) throws PropertiesException {
        if (inReader == null) {
            throw new NullPointerException("Reader is null.");
        }
        PropertiesParser.readMap(this, inReader);
    }

    public MapProperties(String inPath) throws PropertiesException, FileNotFoundException {
        if (inPath == null) {
            throw new NullPointerException("Path is null.");
        }
        PropertiesParser.readMap(this, new DataSource(inPath));
    }

    public MapProperties(String[] inParameters) {
        for (int i = 0; i < inParameters.length; ++i) {
            Object value;
            int p = inParameters[i].indexOf(61);
            if (p == -1) {
                this.put(inParameters[i], Null.INSTANCE);
                continue;
            }
            String argument = inParameters[i].substring(p + 1);
            try {
                value = PropertiesParser.readObject(argument);
            }
            catch (PropertiesException e) {
                throw new PropertiesException("Cannot parse argument: " + argument, e);
            }
            this.put(inParameters[i].substring(0, p), value);
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object inKey) {
        return this.map.containsKey(inKey);
    }

    public boolean containsValue(Object inValue) {
        return this.map.containsValue(inValue);
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public Object get(Object inKey) {
        try {
            return new Context(this).lookup((String)inKey);
        }
        catch (PropertiesException e) {
            throw new PropertiesException("Cannot resolve \"" + inKey + "\", " + e.getMessage(), e);
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Object put(Object inKey, Object inValue) {
        return this.putProperty(new Context(this), (String)inKey, inValue);
    }

    public void putAll(Map inMap) {
        Iterator i = inMap.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            this.put(key, inMap.get(key));
        }
    }

    public Object remove(Object inKey) {
        String key = (String)inKey;
        int p = key.lastIndexOf(46);
        if (p > 0) {
            String leftKey = key.substring(0, p);
            String removeKey = key.substring(p + 1);
            Object value = this.get(leftKey);
            if (value instanceof Map) {
                return ((Map)value).remove(removeKey);
            }
            throw new PropertiesException("Cannot remove " + key + ", " + leftKey + " is not a map.");
        }
        return this.map.remove(key);
    }

    public void setSuper(Properties inProperties) {
        this.map.put(SUPER, inProperties);
    }

    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return this.map.values();
    }

    public Map getMap() {
        return this.map;
    }

    public boolean containsKeyInternal(String inKey) {
        return this.map.containsKey(inKey);
    }

    Properties copy(Properties inParent) {
        MapProperties newProperties = new MapProperties(inParent);
        Iterator i = this.map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value = this.map.get(key);
            if (value instanceof Properties) {
                newProperties.map.put(key, ((Properties)value).copy(newProperties));
                continue;
            }
            if (value instanceof Replaceable) {
                newProperties.map.put(key, ((Replaceable)value).copy(newProperties));
                continue;
            }
            newProperties.map.put(key, value);
        }
        return newProperties;
    }

    public Object getInternal(String inKey) {
        return this.map.get(inKey);
    }

    Object getProperty(Context inContext, String inKey) throws PropertiesException {
        int p = inKey.indexOf(46);
        if (p > 0) {
            Properties inner;
            String localKey = inKey.substring(0, p);
            String rightKey = inKey.substring(p + 1);
            if (localKey.equals(JOKER)) {
                return this.createJokerMap(inContext, rightKey);
            }
            if (localKey.equals(SYSTEM)) {
                return this.getSystemProperty(inContext, rightKey);
            }
            Object value = this.map.get(localKey);
            if (value == null) {
                value = this.checkDelegate(inContext, localKey);
            }
            if (value instanceof Replaceable) {
                value = inContext.replaceReplaceable((Replaceable)value);
            }
            if (value instanceof Properties && (value = (inner = (Properties)value).getProperty(new Context(inContext, inner), rightKey)) != null) {
                return value;
            }
            return this.checkDelegate(inContext, inKey);
        }
        Object value = this.map.get(inKey);
        if (value == null && (value = this.map.get(JOKER)) == null && (value = this.checkDelegate(inContext, inKey)) == null) {
            return null;
        }
        return inContext.replace(value);
    }

    public void putInternal(String inKey, Object inValue) {
        this.map.put(inKey, inValue);
    }

    Object putProperty(Context inContext, String inKey, Object inValue) {
        int p = inKey.indexOf(46);
        if (p > 0) {
            String left = inKey.substring(0, p);
            if (left.equals(SUPER)) {
                throw new PropertiesException("Illegal key \"super\".");
            }
            String right = inKey.substring(p + 1);
            Object value = this.map.get(left);
            if (value == null) {
                p = right.indexOf(46);
                String index = p > 0 ? right.substring(p + 1) : right;
                try {
                    Integer.parseInt(index);
                    value = new ListProperties(this);
                }
                catch (NumberFormatException e) {
                    value = new MapProperties(this);
                }
                this.map.put(left, value);
            } else if (value instanceof Replaceable) {
                value = inContext.replaceReplaceable((Replaceable)value);
            }
            if (value instanceof Properties) {
                Properties inner = (Properties)value;
                return inner.putProperty(new Context(inContext, inner), right, inValue);
            }
            throw new PropertiesException("Cannot put " + inKey + ", " + left + " is not a list or a map.");
        }
        if (inKey.equals(SUPER)) {
            if (!(inValue instanceof String || inValue instanceof Reference || inValue instanceof Proxy || inValue instanceof Properties)) {
                throw new PropertiesException("Value for super must be either null, a path, a reference, a proxy or a map.");
            }
        } else {
            if (inValue instanceof MapProperties) {
                MapProperties m = (MapProperties)inValue;
                Iterator i = m.keySet().iterator();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    this.putProperty(inContext, inKey + "." + key, m.get(key));
                }
                return null;
            }
            if (inValue instanceof Properties) {
                inValue = ((Properties)inValue).copy(this);
            }
        }
        return this.map.put(inKey, inValue);
    }

    void write(Writer inoutWriter) {
        inoutWriter.append("{\n");
        inoutWriter.increaseIndentation();
        Iterator i = this.map.keySet().iterator();
        while (i.hasNext()) {
            inoutWriter.appendIndentation();
            String key = (String)i.next();
            inoutWriter.append(key);
            inoutWriter.append(": ");
            inoutWriter.write(this.map.get(key));
        }
        inoutWriter.decreaseIndentation();
        inoutWriter.appendIndentation();
        inoutWriter.append("}\n");
    }

    private Object checkDelegate(Context inContext, String inKey) throws PropertiesException {
        Object superValue = this.map.get(SUPER);
        if (superValue == null) {
            return null;
        }
        Properties delegate = this.getDelegate(inContext, superValue);
        return delegate.getProperty(inContext, inKey);
    }

    private Object createJokerMap(Context inContext, String inRightKey) throws PropertiesException {
        MapProperties properties = new MapProperties(this.getParent());
        Iterator i = this.map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value = this.map.get(key);
            if (!(value instanceof Properties) || (value = ((Properties)value).getProperty(inContext, inRightKey)) == null) continue;
            properties.putInternal(key, value);
        }
        return properties;
    }

    private Properties getDelegate(Context inContext, Object inSuperValue) throws PropertiesException {
        if (inSuperValue instanceof Reference) {
            String reference = ((Reference)inSuperValue).getReference();
            Properties delegate = (Properties)inContext.getParent().lookup(reference);
            if (delegate == null) {
                throw new PropertiesException("Invalid super reference, \"" + reference + "\" is null.");
            }
            return delegate;
        }
        if (inSuperValue instanceof Proxy) {
            return (Properties)((Proxy)inSuperValue).replace(inContext);
        }
        if (inSuperValue instanceof Properties) {
            return (Properties)inSuperValue;
        }
        if (SYSTEM.equals(inSuperValue)) {
            return SystemProperties.INSTANCE;
        }
        throw new PropertiesException("Invalid super: " + inSuperValue);
    }

    private Object getSystemProperty(Context inContext, String inProperty) {
        Object value;
        String systemProperty = System.getProperty(inProperty);
        if (systemProperty == null) {
            return null;
        }
        try {
            value = PropertiesParser.readObject(systemProperty);
        }
        catch (PropertiesException e) {
            value = systemProperty;
        }
        if (value instanceof String) {
            return inContext.replaceString((String)value);
        }
        if (value instanceof Replaceable) {
            return inContext.replaceReplaceable((Replaceable)value);
        }
        return value;
    }
}

