/*
 * Decompiled with CFR 0.152.
 */
package com.eva.properties;

import com.eva.properties.DataSource;
import com.eva.properties.ListProperties;
import com.eva.properties.MapProperties;
import com.eva.properties.Properties;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Map;

public class PropertiesFactory {
    public static final String DATASOURCE_BASE = "datasource-base";

    public static Map createMap() {
        return new MapProperties();
    }

    public static Map copy(Map inMap) {
        if (inMap == null) {
            throw new NullPointerException();
        }
        if (inMap instanceof MapProperties) {
            Properties properties = (Properties)((Object)inMap);
            return (MapProperties)properties.copy(properties.getParent());
        }
        throw new IllegalArgumentException("Not a properties map.");
    }

    public static Map createMap(Map inMap) {
        return new MapProperties(inMap);
    }

    public static Map createMap(DataSource inDataSource) {
        return new MapProperties(inDataSource);
    }

    public static Map createMap(String inPath) throws IOException {
        return new MapProperties(inPath);
    }

    public static Map createMap(File inFile) throws IOException {
        return new MapProperties(new DataSource(inFile));
    }

    public static Map createMap(InputStream inStream) {
        return new MapProperties(inStream);
    }

    public static Map createMap(Reader inReader) {
        return new MapProperties(inReader);
    }

    public static List createList() {
        return new ListProperties();
    }

    public static List createList(List inList) {
        return new ListProperties(inList);
    }

    public static List createList(Map inMap) {
        return new ListProperties(inMap);
    }

    public static List createList(DataSource inDataSource) {
        return new ListProperties(inDataSource);
    }

    public static List createList(String inPath) throws IOException {
        return new ListProperties(inPath);
    }

    public static List createList(File inFile) throws FileNotFoundException {
        return new ListProperties(new DataSource(inFile));
    }

    public static List createList(InputStream inStream) {
        return new ListProperties(inStream);
    }

    public static List createList(Reader inReader) {
        return new ListProperties(inReader);
    }

    public static Map startParameters(String[] inParameters) {
        return new MapProperties(inParameters);
    }

    private PropertiesFactory() {
    }
}

