/*
 * Decompiled with CFR 0.152.
 */
package com.eva.properties;

import com.eva.properties.DataSource;
import com.eva.properties.Factory;
import com.eva.properties.ListProperties;
import com.eva.properties.MapProperties;
import com.eva.properties.Null;
import com.eva.properties.ParserException;
import com.eva.properties.Properties;
import com.eva.properties.PropertiesException;
import com.eva.properties.Proxy;
import com.eva.properties.Reference;
import com.eva.properties.Replaceable;
import com.eva.properties.Switch;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class PropertiesParser {
    private StreamTokenizer st;
    private Properties current;

    private PropertiesParser(Reader inReader) {
        if (inReader == null) {
            throw new NullPointerException();
        }
        this.st = new StreamTokenizer(inReader);
        this.st.resetSyntax();
        this.st.wordChars(97, 122);
        this.st.wordChars(65, 90);
        this.st.parseNumbers();
        this.st.wordChars(160, 255);
        this.st.wordChars(95, 95);
        this.st.whitespaceChars(0, 32);
        this.st.quoteChar(34);
        this.st.quoteChar(39);
        this.st.ordinaryChar(46);
        this.st.eolIsSignificant(true);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
    }

    static Object readObject(String inString) throws PropertiesException {
        try {
            return PropertiesParser.readObject(new StringReader(inString));
        }
        catch (IOException e) {
            throw new PropertiesException(e);
        }
    }

    static Properties read(DataSource inDataSource) throws IOException, PropertiesException {
        return PropertiesParser.read(null, inDataSource);
    }

    static Properties read(Properties inParent, DataSource inDataSource) throws IOException, PropertiesException {
        Properties properties = new PropertiesParser(inDataSource.getReader()).mapOrList(inParent);
        if (properties instanceof MapProperties) {
            PropertiesParser.initMap((MapProperties)properties, inDataSource);
        } else {
            PropertiesParser.initList((ListProperties)properties, inDataSource);
        }
        return properties;
    }

    static void readMap(MapProperties inoutMap, DataSource inDataSource) throws PropertiesException {
        PropertiesParser parser = new PropertiesParser(inDataSource.getReader());
        parser.current = inoutMap;
        try {
            parser.map(inoutMap, -1);
        }
        catch (IOException e) {
            throw new PropertiesException(e);
        }
        PropertiesParser.initMap(inoutMap, inDataSource);
    }

    static void readList(ListProperties inoutList, DataSource inDataSource) throws PropertiesException {
        PropertiesParser parser = new PropertiesParser(inDataSource.getReader());
        parser.current = inoutList;
        try {
            parser.list(inoutList, -1);
        }
        catch (IOException e) {
            throw new PropertiesException(e);
        }
        PropertiesParser.initList(inoutList, inDataSource);
    }

    private static void initList(ListProperties inoutList, DataSource inDataSource) {
        Iterator i = inoutList.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof MapProperties) {
                PropertiesParser.initMap((MapProperties)o, inDataSource);
                continue;
            }
            if (!(o instanceof ListProperties)) continue;
            PropertiesParser.initList((ListProperties)o, inDataSource);
        }
    }

    private static void initMap(MapProperties inoutMap, DataSource inDataSource) {
        ClassLoader classLoader;
        if (!inoutMap.containsKeyInternal("datasource-base")) {
            inoutMap.putInternal("datasource-base", inDataSource.getDelegateBase());
        }
        if ((classLoader = inDataSource.getClassLoader()) != null) {
            inoutMap.put("classloader", classLoader);
        }
    }

    static Object readObject(Reader inReader) throws IOException, PropertiesException {
        try {
            return new PropertiesParser(inReader).primary(true);
        }
        catch (ParserException e) {
            throw new PropertiesException(e.getMessage());
        }
    }

    static void readMap(MapProperties inoutProperties, Reader inReader) throws PropertiesException {
        PropertiesParser parser = new PropertiesParser(inReader);
        parser.current = inoutProperties;
        try {
            parser.map(inoutProperties, -1);
        }
        catch (IOException e) {
            throw new PropertiesException(e.getMessage());
        }
    }

    static void readList(ListProperties inoutProperties, Reader inReader) throws PropertiesException {
        PropertiesParser parser = new PropertiesParser(inReader);
        parser.current = inoutProperties;
        try {
            parser.list(inoutProperties, -1);
        }
        catch (IOException e) {
            throw new PropertiesException(e);
        }
    }

    private Properties mapOrList(Properties inParent) throws IOException, PropertiesException {
        Object primary;
        try {
            primary = this.primary(true);
        }
        catch (ParserException e) {
            switch (this.st.ttype) {
                case 42: {
                    primary = "*";
                    this.st.nextToken();
                    break;
                }
                case 58: {
                    if (!"*".equals(e.getMessage())) {
                        throw new PropertiesException(e.getMessage());
                    }
                    primary = "*";
                    break;
                }
                default: {
                    throw new PropertiesException(e.getMessage());
                }
            }
        }
        if (this.st.ttype == 58 || this.st.ttype == 61) {
            if (!(primary instanceof String)) {
                throw new PropertiesException("String expected, " + primary.getClass().getName());
            }
            MapProperties map = new MapProperties(inParent);
            this.current = map;
            try {
                map.putInternal((String)primary, this.primary(true));
            }
            catch (ParserException e) {
                throw new PropertiesException(e.getMessage());
            }
            this.map(map, -1);
            return map;
        }
        ListProperties list = new ListProperties(inParent);
        this.current = list;
        if (primary instanceof Properties) {
            ((Properties)primary).setParent(list);
        }
        list.add(primary);
        if (this.st.ttype == -1) {
            return this.current;
        }
        this.list(list, -1);
        return list;
    }

    private String token(int inToken) {
        switch (inToken) {
            case -3: {
                return this.st.sval;
            }
            case 39: {
                return '\'' + this.st.sval + '\'';
            }
            case 34: {
                return '\"' + this.st.sval + '\"';
            }
            case -2: {
                return String.valueOf(this.st.nval);
            }
            case -1: {
                return "EOF";
            }
            case 10: {
                return "EOL";
            }
        }
        return "" + (char)inToken;
    }

    private String error() {
        return this.token(this.st.ttype) + " line " + this.st.lineno();
    }

    private Number number(double inNumber) throws IOException {
        if (this.st.nextToken() == 46) {
            if (this.st.nextToken() != -2) {
                throw new IllegalStateException("Number expected, " + this.error());
            }
            this.st.nextToken();
            return Double.valueOf(inNumber + "." + this.st.nval);
        }
        if ((double)((long)inNumber) == inNumber) {
            return new Long((long)inNumber);
        }
        return new Double(inNumber);
    }

    private Object primary(boolean inGet) throws IOException, ParserException {
        int token;
        int n = token = inGet ? this.st.nextToken() : this.st.ttype;
        while (token == 10) {
            token = this.st.nextToken();
        }
        switch (token) {
            case -3: {
                String s = this.st.sval;
                this.st.nextToken();
                if ("null".equals(s) || "nil".equals(s)) {
                    return Null.INSTANCE;
                }
                if ("true".equals(s) || "yes".equals(s) || "on".equals(s)) {
                    return Boolean.TRUE;
                }
                if ("false".equals(s) || "no".equals(s) || "off".equals(s)) {
                    return Boolean.FALSE;
                }
                return s;
            }
            case -2: {
                return this.number(this.st.nval);
            }
            case 39: {
                String s = this.st.sval;
                this.st.nextToken();
                if (s.length() == 1) {
                    return new Character(s.charAt(0));
                }
                return s.toCharArray();
            }
            case 34: {
                String s = this.st.sval;
                this.st.nextToken();
                return s;
            }
            case 91: {
                ListProperties list = new ListProperties(this.current);
                this.current = list;
                this.list(list, 93);
                this.current = list.getParent();
                return list;
            }
            case 123: {
                MapProperties map = new MapProperties(this.current);
                this.current = map;
                this.map(map, 125);
                this.current = map.getParent();
                return map;
            }
            case 36: {
                return this.reference();
            }
            case 46: {
                return this.doubleNumber();
            }
            case 40: {
                return this.switcher();
            }
            case 38: {
                return this.proxy();
            }
            case 42: {
                return this.factory();
            }
        }
        throw new PropertiesException("Unexpected token, " + this.error());
    }

    private Factory factory() throws IOException, ParserException {
        List arguments = null;
        StringBuffer className = new StringBuffer();
        block9: while (true) {
            switch (this.st.nextToken()) {
                case -3: {
                    className.append(this.st.sval);
                    continue block9;
                }
                case 46: {
                    className.append('.');
                    continue block9;
                }
                case 36: {
                    className.append('$');
                    continue block9;
                }
                case 123: {
                    className.append('{');
                    continue block9;
                }
                case 125: {
                    className.append('}');
                    continue block9;
                }
                case 40: {
                    arguments = this.list(41);
                    return new Factory(className.toString(), arguments.toArray());
                }
                case 58: {
                    if (className.length() != 0) break block9;
                    throw new ParserException("*");
                }
            }
            break;
        }
        return new Factory(className.toString(), null);
    }

    private Proxy proxy() throws IOException, PropertiesException {
        Object object;
        boolean proxyParent = this.st.nextToken() != 33;
        try {
            object = this.primary(!proxyParent);
        }
        catch (ParserException e) {
            throw new PropertiesException(e.getMessage());
        }
        if (object instanceof String) {
            return new Proxy(proxyParent ? this.current : null, (String)object);
        }
        if (object instanceof Replaceable) {
            return new Proxy(proxyParent ? this.current : null, (Replaceable)object);
        }
        throw new PropertiesException("String or Replaceable expected, " + object.getClass().getName());
    }

    private Switch switcher() throws IOException, PropertiesException {
        this.st.nextToken();
        Switch s = new Switch();
        while (this.st.ttype != 41) {
            try {
                s.add(this.primary(false));
            }
            catch (ParserException e) {
                throw new PropertiesException(e.getMessage());
            }
            if (this.st.ttype != 44 && this.st.ttype != 10) {
                if (this.st.ttype == 41) break;
                throw new PropertiesException(") or , or EOL expected, " + this.error());
            }
            this.overreadEmptyLines();
        }
        this.st.nextToken();
        return s;
    }

    private void overreadEmptyLines() throws IOException {
        do {
            this.st.nextToken();
        } while (this.st.ttype == 10);
    }

    private Double doubleNumber() throws IOException, PropertiesException {
        if (this.st.nextToken() != -2) {
            throw new PropertiesException("Number expected, " + this.error());
        }
        return new Double(this.st.nval);
    }

    private Reference reference() throws IOException, PropertiesException {
        if (this.st.nextToken() != 123) {
            throw new PropertiesException("{ expected, " + this.error());
        }
        StringBuffer reference = new StringBuffer();
        block6: while (this.st.nextToken() != 125) {
            switch (this.st.ttype) {
                case -3: {
                    reference.append(this.st.sval);
                    continue block6;
                }
                case -2: {
                    if ((double)((long)this.st.nval) == this.st.nval) {
                        reference.append((long)this.st.nval);
                        continue block6;
                    }
                    reference.append(this.st.nval);
                    continue block6;
                }
                case 46: {
                    reference.append('.');
                    continue block6;
                }
                case 42: {
                    reference.append('*');
                    continue block6;
                }
            }
            throw new PropertiesException("} expected, " + this.error());
        }
        this.st.nextToken();
        return new Reference(reference.toString());
    }

    private void map(MapProperties inoutMap, int inToToken) throws IOException, PropertiesException {
        this.overreadEmptyLines();
        while (this.st.ttype != inToToken) {
            String key = this.key();
            this.st.nextToken();
            if (this.st.ttype != 58 && this.st.ttype != 61) {
                throw new PropertiesException(": or = expected, " + this.error());
            }
            try {
                inoutMap.putInternal(key, this.primary(true));
            }
            catch (ParserException e) {
                throw new PropertiesException(e.getMessage());
            }
            if (this.st.ttype != 44 && this.st.ttype != 10) {
                if (this.st.ttype == inToToken) break;
                throw new PropertiesException(this.token(inToToken) + " expected, " + this.error());
            }
            this.overreadEmptyLines();
        }
        this.st.nextToken();
    }

    private List list(int inToToken) throws IOException, PropertiesException {
        ArrayList list = new ArrayList();
        this.list(list, inToToken);
        return list;
    }

    private void list(List inoutList, int inToToken) throws IOException, PropertiesException {
        this.overreadEmptyLines();
        while (this.st.ttype != inToToken) {
            try {
                inoutList.add(this.primary(false));
            }
            catch (ParserException e) {
                throw new PropertiesException(e.getMessage());
            }
            if (this.st.ttype != 44 && this.st.ttype != 10) {
                if (this.st.ttype == inToToken) break;
                throw new PropertiesException(this.token(inToToken) + " expected, " + this.error());
            }
            this.overreadEmptyLines();
        }
        this.st.nextToken();
    }

    private String key() throws IOException {
        while (this.st.ttype == 10) {
            this.st.nextToken();
        }
        switch (this.st.ttype) {
            case -2: {
                if ((double)((int)this.st.nval) == this.st.nval) {
                    return String.valueOf((long)this.st.nval);
                }
                return String.valueOf(this.st.nval);
            }
            case -3: 
            case 34: 
            case 39: {
                return this.st.sval;
            }
            case 42: {
                return "*";
            }
        }
        throw new PropertiesException("Unexpected token, " + this.error());
    }
}

