/*
 * Decompiled with CFR 0.152.
 */
package com.eva.properties;

import com.eva.properties.Context;
import com.eva.properties.DataSource;
import com.eva.properties.Log;
import com.eva.properties.NoProperties;
import com.eva.properties.Null;
import com.eva.properties.Properties;
import com.eva.properties.PropertiesException;
import com.eva.properties.PropertiesParser;
import com.eva.properties.Replaceable;
import com.eva.properties.Replacer;
import com.eva.properties.Writer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;

public class Proxy
implements Replaceable {
    private Object object;
    private Properties parent;
    private Type type;

    public Proxy(String inPath) {
        if (inPath == null) {
            throw new NullPointerException("Path cannot be null.");
        }
        if ("".equals(inPath)) {
            throw new IllegalArgumentException("Path cannot be empty.");
        }
        this.type = new TypePath(inPath);
    }

    Proxy(Properties inParent, Replaceable inReplaceable) {
        if (inReplaceable == null) {
            throw new NullPointerException("Replaceable cannot be null.");
        }
        this.parent = inParent;
        this.type = new TypeReplaceable(inReplaceable);
    }

    Proxy(Properties inParent, String inPath) {
        this(inPath);
        this.parent = inParent;
    }

    private Proxy(Properties inParent, Type inType) {
        this(inType);
        this.parent = inParent;
    }

    private Proxy(Type inType) {
        this.type = inType;
    }

    public Replaceable copy(Properties inParent) {
        Proxy proxy = new Proxy(inParent, this.type);
        if (this.object != null) {
            proxy.object = this.object instanceof Replaceable ? ((Replaceable)this.object).copy(inParent) : this.object;
        }
        return proxy;
    }

    public Object replace(Context inContext) throws PropertiesException {
        if (this.object == null) {
            this.object = this.type.getNullObject();
            this.object = this.type.resolve(this.parent, inContext);
        }
        return this.object;
    }

    public String toString() {
        return this.type.toString();
    }

    public void write(Writer inoutWriter) {
        inoutWriter.append(this.type.toString());
        inoutWriter.append("\n");
    }

    void setParent(Properties inParent) {
        this.parent = inParent;
    }

    private static class TypeReplaceable
    implements Type {
        private Replaceable replaceable;

        TypeReplaceable(Replaceable inReplaceable) {
            this.replaceable = inReplaceable;
        }

        public Object resolve(Properties inParent, Context inContext) {
            return this.replaceable.replace(inContext);
        }

        public String toString() {
            return "&" + this.replaceable.toString();
        }

        public Object getNullObject() {
            return Null.INSTANCE;
        }
    }

    private static class TypePath
    implements Type {
        private String path;

        TypePath(String inPath) {
            this.path = inPath;
        }

        public Object resolve(Properties inParent, Context inContext) {
            DataSource dataSource;
            String replacedPath = Replacer.replace(this.path, inContext);
            if (replacedPath == null) {
                return Null.INSTANCE;
            }
            try {
                dataSource = new DataSource((ClassLoader)inContext.lookup("classloader"), replacedPath);
            }
            catch (FileNotFoundException e) {
                Log.instance().log(Level.FINE, "PropertiesProxy.fileNotFound", replacedPath);
                return Null.INSTANCE;
            }
            if (Log.instance().isLoggable(Level.CONFIG)) {
                Log.instance().log(Level.CONFIG, "PropertiesProxy.readingProperties", dataSource.toString());
            }
            try {
                return PropertiesParser.read(inParent, dataSource);
            }
            catch (IOException e) {
                throw new PropertiesException("IOException while reading super properties " + replacedPath + ": " + e.getMessage());
            }
            catch (PropertiesException e) {
                throw new PropertiesException("PropertiesException while reading super properties " + replacedPath + ": " + e.getMessage());
            }
        }

        public String toString() {
            return "&\"" + this.path + "\"";
        }

        public Object getNullObject() {
            return NoProperties.INSTANCE;
        }
    }

    private static interface Type {
        public Object resolve(Properties var1, Context var2);

        public Object getNullObject();
    }
}

