/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.facebook.presto.hadoop.$internal.org.apache.avro.file.SeekableInput;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class AvroFSInput
implements Closeable,
SeekableInput {
    private final FSDataInputStream stream;
    private final long len;

    public AvroFSInput(FSDataInputStream in, long len) {
        this.stream = in;
        this.len = len;
    }

    public AvroFSInput(FileContext fc, Path p) throws IOException {
        FileStatus status = fc.getFileStatus(p);
        this.len = status.getLen();
        this.stream = fc.open(p);
    }

    @Override
    public long length() {
        return this.len;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    @Override
    public void seek(long p) throws IOException {
        this.stream.seek(p);
    }

    @Override
    public long tell() throws IOException {
        return this.stream.getPos();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

