/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.balancer;

import com.facebook.presto.hadoop.$internal.com.google.common.base.Preconditions;
import com.facebook.presto.hadoop.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.balancer.BalancingPolicy;
import org.apache.hadoop.hdfs.server.balancer.Dispatcher;
import org.apache.hadoop.hdfs.server.balancer.ExitStatus;
import org.apache.hadoop.hdfs.server.balancer.Matcher;
import org.apache.hadoop.hdfs.server.balancer.NameNodeConnector;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.namenode.UnsupportedActionException;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class Balancer {
    static final Log LOG = LogFactory.getLog(Balancer.class);
    static final Path BALANCER_ID_PATH = new Path("/system/balancer.id");
    private static final long GB = 0x40000000L;
    private static final long MAX_SIZE_TO_MOVE = 0x280000000L;
    private static final String USAGE = "Usage: hdfs balancer\n\t[-policy <policy>]\tthe balancing policy: " + BalancingPolicy.Node.INSTANCE.getName() + " or " + BalancingPolicy.Pool.INSTANCE.getName() + "\n\t[-threshold <threshold>]\tPercentage of disk capacity" + "\n\t[-exclude [-f <hosts-file> | <comma-separated list of hosts>]]" + "\tExcludes the specified datanodes." + "\n\t[-include [-f <hosts-file> | <comma-separated list of hosts>]]" + "\tIncludes only the specified datanodes." + "\n\t[-idleiterations <idleiterations>]" + "\tNumber of consecutive idle iterations (-1 for Infinite) before exit.";
    private final Dispatcher dispatcher;
    private final BalancingPolicy policy;
    private final double threshold;
    private final Collection<Dispatcher.Source> overUtilized = new LinkedList<Dispatcher.Source>();
    private final Collection<Dispatcher.Source> aboveAvgUtilized = new LinkedList<Dispatcher.Source>();
    private final Collection<Dispatcher.DDatanode.StorageGroup> belowAvgUtilized = new LinkedList<Dispatcher.DDatanode.StorageGroup>();
    private final Collection<Dispatcher.DDatanode.StorageGroup> underUtilized = new LinkedList<Dispatcher.DDatanode.StorageGroup>();

    private static void checkReplicationPolicyCompatibility(Configuration conf) throws UnsupportedActionException {
        if (!(BlockPlacementPolicy.getInstance(conf, null, null, null) instanceof BlockPlacementPolicyDefault)) {
            throw new UnsupportedActionException("Balancer without BlockPlacementPolicyDefault");
        }
    }

    Balancer(NameNodeConnector theblockpool, Parameters p, Configuration conf) {
        long movedWinWidth = conf.getLong("dfs.balancer.movedWinWidth", 5400000L);
        int moverThreads = conf.getInt("dfs.balancer.moverThreads", 1000);
        int dispatcherThreads = conf.getInt("dfs.balancer.dispatcherThreads", 200);
        int maxConcurrentMovesPerNode = conf.getInt("dfs.datanode.balance.max.concurrent.moves", 5);
        this.dispatcher = new Dispatcher(theblockpool, p.nodesToBeIncluded, p.nodesToBeExcluded, movedWinWidth, moverThreads, dispatcherThreads, maxConcurrentMovesPerNode, conf);
        this.threshold = p.threshold;
        this.policy = p.policy;
    }

    private static long getCapacity(DatanodeStorageReport report, StorageType t) {
        long capacity = 0L;
        for (StorageReport r : report.getStorageReports()) {
            if (r.getStorage().getStorageType() != t) continue;
            capacity += r.getCapacity();
        }
        return capacity;
    }

    private static long getRemaining(DatanodeStorageReport report, StorageType t) {
        long remaining = 0L;
        for (StorageReport r : report.getStorageReports()) {
            if (r.getStorage().getStorageType() != t) continue;
            remaining += r.getRemaining();
        }
        return remaining;
    }

    private long init(List<DatanodeStorageReport> reports) {
        for (DatanodeStorageReport r : reports) {
            this.policy.accumulateSpaces(r);
        }
        this.policy.initAvgUtilization();
        long overLoadedBytes = 0L;
        long underLoadedBytes = 0L;
        for (DatanodeStorageReport r : reports) {
            Dispatcher.DDatanode dn = this.dispatcher.newDatanode(r.getDatanodeInfo());
            for (StorageType t : StorageType.getMovableTypes()) {
                Dispatcher.DDatanode.StorageGroup g;
                Double utilization = this.policy.getUtilization(r, t);
                if (utilization == null) continue;
                long capacity = Balancer.getCapacity(r, t);
                double utilizationDiff = utilization - this.policy.getAvgUtilization(t);
                double thresholdDiff = Math.abs(utilizationDiff) - this.threshold;
                long maxSize2Move = Balancer.computeMaxSize2Move(capacity, Balancer.getRemaining(r, t), utilizationDiff, this.threshold);
                if (utilizationDiff > 0.0) {
                    Dispatcher.Source s = dn.addSource(t, maxSize2Move, this.dispatcher);
                    if (thresholdDiff <= 0.0) {
                        this.aboveAvgUtilized.add(s);
                    } else {
                        overLoadedBytes += Balancer.precentage2bytes(thresholdDiff, capacity);
                        this.overUtilized.add(s);
                    }
                    g = s;
                } else {
                    g = dn.addTarget(t, maxSize2Move);
                    if (thresholdDiff <= 0.0) {
                        this.belowAvgUtilized.add(g);
                    } else {
                        underLoadedBytes += Balancer.precentage2bytes(thresholdDiff, capacity);
                        this.underUtilized.add(g);
                    }
                }
                this.dispatcher.getStorageGroupMap().put(g);
            }
        }
        this.logUtilizationCollections();
        Preconditions.checkState(this.dispatcher.getStorageGroupMap().size() == this.overUtilized.size() + this.underUtilized.size() + this.aboveAvgUtilized.size() + this.belowAvgUtilized.size(), "Mismatched number of storage groups");
        return Math.max(overLoadedBytes, underLoadedBytes);
    }

    private static long computeMaxSize2Move(long capacity, long remaining, double utilizationDiff, double threshold) {
        double diff = Math.min(threshold, Math.abs(utilizationDiff));
        long maxSizeToMove = Balancer.precentage2bytes(diff, capacity);
        if (utilizationDiff < 0.0) {
            maxSizeToMove = Math.min(remaining, maxSizeToMove);
        }
        return Math.min(0x280000000L, maxSizeToMove);
    }

    private static long precentage2bytes(double precentage, long capacity) {
        Preconditions.checkArgument(precentage >= 0.0, "precentage = " + precentage + " < 0");
        return (long)(precentage * (double)capacity / 100.0);
    }

    private void logUtilizationCollections() {
        Balancer.logUtilizationCollection("over-utilized", this.overUtilized);
        if (LOG.isTraceEnabled()) {
            Balancer.logUtilizationCollection("above-average", this.aboveAvgUtilized);
            Balancer.logUtilizationCollection("below-average", this.belowAvgUtilized);
        }
        Balancer.logUtilizationCollection("underutilized", this.underUtilized);
    }

    private static <T extends Dispatcher.DDatanode.StorageGroup> void logUtilizationCollection(String name, Collection<T> items) {
        LOG.info(items.size() + " " + name + ": " + items);
    }

    private long chooseStorageGroups() {
        if (this.dispatcher.getCluster().isNodeGroupAware()) {
            this.chooseStorageGroups(Matcher.SAME_NODE_GROUP);
        }
        this.chooseStorageGroups(Matcher.SAME_RACK);
        this.chooseStorageGroups(Matcher.ANY_OTHER);
        return this.dispatcher.bytesToMove();
    }

    private void chooseStorageGroups(Matcher matcher) {
        this.chooseStorageGroups(this.overUtilized, this.underUtilized, matcher);
        this.chooseStorageGroups(this.overUtilized, this.belowAvgUtilized, matcher);
        this.chooseStorageGroups(this.underUtilized, this.aboveAvgUtilized, matcher);
    }

    private <G extends Dispatcher.DDatanode.StorageGroup, C extends Dispatcher.DDatanode.StorageGroup> void chooseStorageGroups(Collection<G> groups, Collection<C> candidates, Matcher matcher) {
        Iterator<G> i = groups.iterator();
        while (i.hasNext()) {
            Dispatcher.DDatanode.StorageGroup g = (Dispatcher.DDatanode.StorageGroup)i.next();
            while (this.choose4One(g, candidates, matcher)) {
            }
            if (g.hasSpaceForScheduling()) continue;
            i.remove();
        }
    }

    private <C extends Dispatcher.DDatanode.StorageGroup> boolean choose4One(Dispatcher.DDatanode.StorageGroup g, Collection<C> candidates, Matcher matcher) {
        Iterator<C> i = candidates.iterator();
        C chosen = this.chooseCandidate(g, i, matcher);
        if (chosen == null) {
            return false;
        }
        if (g instanceof Dispatcher.Source) {
            this.matchSourceWithTargetToMove((Dispatcher.Source)g, (Dispatcher.DDatanode.StorageGroup)chosen);
        } else {
            this.matchSourceWithTargetToMove((Dispatcher.Source)chosen, g);
        }
        if (!((Dispatcher.DDatanode.StorageGroup)chosen).hasSpaceForScheduling()) {
            i.remove();
        }
        return true;
    }

    private void matchSourceWithTargetToMove(Dispatcher.Source source, Dispatcher.DDatanode.StorageGroup target) {
        long size = Math.min(source.availableSizeToMove(), target.availableSizeToMove());
        Dispatcher.Task task = new Dispatcher.Task(target, size);
        source.addTask(task);
        target.incScheduledSize(task.getSize());
        this.dispatcher.add(source, target);
        LOG.info("Decided to move " + StringUtils.byteDesc(size) + " bytes from " + source.getDisplayName() + " to " + target.getDisplayName());
    }

    private <G extends Dispatcher.DDatanode.StorageGroup, C extends Dispatcher.DDatanode.StorageGroup> C chooseCandidate(G g, Iterator<C> candidates, Matcher matcher) {
        if (g.hasSpaceForScheduling()) {
            while (candidates.hasNext()) {
                Dispatcher.DDatanode.StorageGroup c = (Dispatcher.DDatanode.StorageGroup)candidates.next();
                if (!c.hasSpaceForScheduling()) {
                    candidates.remove();
                    continue;
                }
                if (!this.matchStorageGroups(c, g, matcher)) continue;
                return (C)c;
            }
        }
        return null;
    }

    private boolean matchStorageGroups(Dispatcher.DDatanode.StorageGroup left, Dispatcher.DDatanode.StorageGroup right, Matcher matcher) {
        return left.getStorageType() == right.getStorageType() && matcher.match(this.dispatcher.getCluster(), left.getDatanodeInfo(), right.getDatanodeInfo());
    }

    void resetData(Configuration conf) {
        this.overUtilized.clear();
        this.aboveAvgUtilized.clear();
        this.belowAvgUtilized.clear();
        this.underUtilized.clear();
        this.policy.reset();
        this.dispatcher.reset(conf);
    }

    Result newResult(ExitStatus exitStatus, long bytesLeftToMove, long bytesBeingMoved) {
        return new Result(exitStatus, bytesLeftToMove, bytesBeingMoved, this.dispatcher.getBytesMoved());
    }

    Result newResult(ExitStatus exitStatus) {
        return new Result(exitStatus, -1L, -1L, this.dispatcher.getBytesMoved());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result runOneIteration() {
        try {
            List<DatanodeStorageReport> reports = this.dispatcher.init();
            long bytesLeftToMove = this.init(reports);
            if (bytesLeftToMove == 0L) {
                System.out.println("The cluster is balanced. Exiting...");
                Result result = this.newResult(ExitStatus.SUCCESS, bytesLeftToMove, -1L);
                return result;
            }
            LOG.info("Need to move " + StringUtils.byteDesc(bytesLeftToMove) + " to make the cluster balanced.");
            long bytesBeingMoved = this.chooseStorageGroups();
            if (bytesBeingMoved == 0L) {
                System.out.println("No block can be moved. Exiting...");
                Result result = this.newResult(ExitStatus.NO_MOVE_BLOCK, bytesLeftToMove, bytesBeingMoved);
                return result;
            }
            LOG.info("Will move " + StringUtils.byteDesc(bytesBeingMoved) + " in this iteration");
            if (!this.dispatcher.dispatchAndCheckContinue()) {
                Result result = this.newResult(ExitStatus.NO_MOVE_PROGRESS, bytesLeftToMove, bytesBeingMoved);
                return result;
            }
            Result result = this.newResult(ExitStatus.IN_PROGRESS, bytesLeftToMove, bytesBeingMoved);
            return result;
        }
        catch (IllegalArgumentException e) {
            System.out.println(e + ".  Exiting ...");
            Result result = this.newResult(ExitStatus.ILLEGAL_ARGUMENTS);
            return result;
        }
        catch (IOException e) {
            System.out.println(e + ".  Exiting ...");
            Result result = this.newResult(ExitStatus.IO_EXCEPTION);
            return result;
        }
        catch (InterruptedException e) {
            System.out.println(e + ".  Exiting ...");
            Result result = this.newResult(ExitStatus.INTERRUPTED);
            return result;
        }
        finally {
            this.dispatcher.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int run(Collection<URI> namenodes, Parameters p, Configuration conf) throws IOException, InterruptedException {
        block14: {
            block13: {
                sleeptime = conf.getLong("dfs.heartbeat.interval", 3L) * 2000L + conf.getLong("dfs.namenode.replication.interval", 3L) * 1000L;
                Balancer.LOG.info("namenodes  = " + namenodes);
                Balancer.LOG.info("parameters = " + p);
                System.out.println("Time Stamp               Iteration#  Bytes Already Moved  Bytes Left To Move  Bytes Being Moved");
                connectors = Collections.emptyList();
                try {
                    connectors = NameNodeConnector.newNameNodeConnectors(namenodes, Balancer.class.getSimpleName(), Balancer.BALANCER_ID_PATH, conf, p.maxIdleIteration);
                    done = false;
                    var7_7 = false;
lbl10:
                    // 2 sources

                    while (!done) {
                        done = true;
                        Collections.shuffle(connectors);
                        for (NameNodeConnector var9_11 : connectors) {
                            b = new Balancer(var9_11, p, conf);
                            r = b.runOneIteration();
                            r.print((int)var7_8, System.out);
                            b.resetData(conf);
                            if (r.exitStatus == ExitStatus.IN_PROGRESS) {
                                done = false;
                                continue;
                            }
                            if (r.exitStatus == ExitStatus.SUCCESS) continue;
                            var12_14 = r.exitStatus.getExitCode();
                            var13_15 = connectors.iterator();
                            break block13;
                        }
                        ** GOTO lbl-1000
                    }
                    break block14;
                }
                catch (Throwable var15_17) {
                    var16_18 = connectors.iterator();
                    while (true) {
                        if (!var16_18.hasNext()) {
                            throw var15_17;
                        }
                        var17_19 = (NameNodeConnector)var16_18.next();
                        IOUtils.cleanup(Balancer.LOG, new Closeable[]{var17_19});
                    }
                }
            }
            while (true) {
                if (!var13_15.hasNext()) {
                    return var12_14;
                }
                var14_16 = (NameNodeConnector)var13_15.next();
                IOUtils.cleanup(Balancer.LOG, new Closeable[]{var14_16});
            }
lbl-1000:
            // 1 sources

            {
                if (!done) {
                    Thread.sleep(sleeptime);
                }
                ++var7_8;
                ** GOTO lbl10
            }
        }
        var6_6 = connectors.iterator();
        while (true) {
            if (!var6_6.hasNext()) {
                return ExitStatus.SUCCESS.getExitCode();
            }
            var7_9 = (NameNodeConnector)var6_6.next();
            IOUtils.cleanup(Balancer.LOG, new Closeable[]{var7_9});
        }
    }

    private static String time2Str(long elapsedTime) {
        String unit;
        double time = elapsedTime;
        if (elapsedTime < 1000L) {
            unit = "milliseconds";
        } else if (elapsedTime < 60000L) {
            unit = "seconds";
            time /= 1000.0;
        } else if (elapsedTime < 3600000L) {
            unit = "minutes";
            time /= 60000.0;
        } else {
            unit = "hours";
            time /= 3600000.0;
        }
        return time + " " + unit;
    }

    public static void main(String[] args) {
        if (DFSUtil.parseHelpArgument(args, USAGE, System.out, true)) {
            System.exit(0);
        }
        try {
            System.exit(ToolRunner.run(new HdfsConfiguration(), new Cli(), args));
        }
        catch (Throwable e) {
            LOG.error("Exiting balancer due an exception", e);
            System.exit(-1);
        }
    }

    static class Cli
    extends Configured
    implements Tool {
        Cli() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public int run(String[] args) {
            int n;
            long startTime = Time.monotonicNow();
            Configuration conf = this.getConf();
            try {
                Balancer.checkReplicationPolicyCompatibility(conf);
                Collection<URI> namenodes = DFSUtil.getInternalNsRpcUris(conf);
                n = Balancer.run(namenodes, Cli.parse(args), conf);
            }
            catch (IOException e) {
                System.out.println(e + ".  Exiting ...");
                int n2 = ExitStatus.IO_EXCEPTION.getExitCode();
                System.out.format("%-24s ", DateFormat.getDateTimeInstance().format(new Date()));
                System.out.println("Balancing took " + Balancer.time2Str(Time.monotonicNow() - startTime));
                return n2;
            }
            catch (InterruptedException e2) {
                System.out.println(e2 + ".  Exiting ...");
                int n3 = ExitStatus.INTERRUPTED.getExitCode();
                {
                    catch (Throwable throwable) {
                        System.out.format("%-24s ", DateFormat.getDateTimeInstance().format(new Date()));
                        System.out.println("Balancing took " + Balancer.time2Str(Time.monotonicNow() - startTime));
                        throw throwable;
                    }
                }
                System.out.format("%-24s ", DateFormat.getDateTimeInstance().format(new Date()));
                System.out.println("Balancing took " + Balancer.time2Str(Time.monotonicNow() - startTime));
                return n3;
            }
            System.out.format("%-24s ", DateFormat.getDateTimeInstance().format(new Date()));
            System.out.println("Balancing took " + Balancer.time2Str(Time.monotonicNow() - startTime));
            return n;
        }

        static Parameters parse(String[] args) {
            BalancingPolicy policy = Parameters.DEFAULT.policy;
            double threshold = Parameters.DEFAULT.threshold;
            int maxIdleIteration = Parameters.DEFAULT.maxIdleIteration;
            Set<String> nodesTobeExcluded = Parameters.DEFAULT.nodesToBeExcluded;
            Set<String> nodesTobeIncluded = Parameters.DEFAULT.nodesToBeIncluded;
            if (args != null) {
                try {
                    for (int i = 0; i < args.length; ++i) {
                        if ("-threshold".equalsIgnoreCase(args[i])) {
                            Preconditions.checkArgument(++i < args.length, "Threshold value is missing: args = " + Arrays.toString(args));
                            try {
                                threshold = Double.parseDouble(args[i]);
                                if (threshold < 1.0 || threshold > 100.0) {
                                    throw new IllegalArgumentException("Number out of range: threshold = " + threshold);
                                }
                                LOG.info("Using a threshold of " + threshold);
                                continue;
                            }
                            catch (IllegalArgumentException e) {
                                System.err.println("Expecting a number in the range of [1.0, 100.0]: " + args[i]);
                                throw e;
                            }
                        }
                        if ("-policy".equalsIgnoreCase(args[i])) {
                            Preconditions.checkArgument(++i < args.length, "Policy value is missing: args = " + Arrays.toString(args));
                            try {
                                policy = BalancingPolicy.parse(args[i]);
                                continue;
                            }
                            catch (IllegalArgumentException e) {
                                System.err.println("Illegal policy name: " + args[i]);
                                throw e;
                            }
                        }
                        if ("-exclude".equalsIgnoreCase(args[i])) {
                            Preconditions.checkArgument(++i < args.length, "List of nodes to exclude | -f <filename> is missing: args = " + Arrays.toString(args));
                            if ("-f".equalsIgnoreCase(args[i])) {
                                Preconditions.checkArgument(++i < args.length, "File containing nodes to exclude is not specified: args = " + Arrays.toString(args));
                                nodesTobeExcluded = Dispatcher.Util.getHostListFromFile(args[i], "exclude");
                                continue;
                            }
                            nodesTobeExcluded = Dispatcher.Util.parseHostList(args[i]);
                            continue;
                        }
                        if ("-include".equalsIgnoreCase(args[i])) {
                            Preconditions.checkArgument(++i < args.length, "List of nodes to include | -f <filename> is missing: args = " + Arrays.toString(args));
                            if ("-f".equalsIgnoreCase(args[i])) {
                                Preconditions.checkArgument(++i < args.length, "File containing nodes to include is not specified: args = " + Arrays.toString(args));
                                nodesTobeIncluded = Dispatcher.Util.getHostListFromFile(args[i], "include");
                                continue;
                            }
                            nodesTobeIncluded = Dispatcher.Util.parseHostList(args[i]);
                            continue;
                        }
                        if ("-idleiterations".equalsIgnoreCase(args[i])) {
                            Preconditions.checkArgument(++i < args.length, "idleiterations value is missing: args = " + Arrays.toString(args));
                            maxIdleIteration = Integer.parseInt(args[i]);
                            LOG.info("Using a idleiterations of " + maxIdleIteration);
                            continue;
                        }
                        throw new IllegalArgumentException("args = " + Arrays.toString(args));
                    }
                    Preconditions.checkArgument(nodesTobeExcluded.isEmpty() || nodesTobeIncluded.isEmpty(), "-exclude and -include options cannot be specified together.");
                }
                catch (RuntimeException e) {
                    Cli.printUsage(System.err);
                    throw e;
                }
            }
            return new Parameters(policy, threshold, maxIdleIteration, nodesTobeExcluded, nodesTobeIncluded);
        }

        private static void printUsage(PrintStream out) {
            out.println(USAGE + "\n");
        }
    }

    static class Parameters {
        static final Parameters DEFAULT = new Parameters(BalancingPolicy.Node.INSTANCE, 10.0, 5, Collections.emptySet(), Collections.emptySet());
        final BalancingPolicy policy;
        final double threshold;
        final int maxIdleIteration;
        Set<String> nodesToBeExcluded;
        Set<String> nodesToBeIncluded;

        Parameters(BalancingPolicy policy, double threshold, int maxIdleIteration, Set<String> nodesToBeExcluded, Set<String> nodesToBeIncluded) {
            this.policy = policy;
            this.threshold = threshold;
            this.maxIdleIteration = maxIdleIteration;
            this.nodesToBeExcluded = nodesToBeExcluded;
            this.nodesToBeIncluded = nodesToBeIncluded;
        }

        public String toString() {
            return Balancer.class.getSimpleName() + "." + this.getClass().getSimpleName() + "[" + this.policy + ", threshold=" + this.threshold + ", max idle iteration = " + this.maxIdleIteration + ", number of nodes to be excluded = " + this.nodesToBeExcluded.size() + ", number of nodes to be included = " + this.nodesToBeIncluded.size() + "]";
        }
    }

    static class Result {
        final ExitStatus exitStatus;
        final long bytesLeftToMove;
        final long bytesBeingMoved;
        final long bytesAlreadyMoved;

        Result(ExitStatus exitStatus, long bytesLeftToMove, long bytesBeingMoved, long bytesAlreadyMoved) {
            this.exitStatus = exitStatus;
            this.bytesLeftToMove = bytesLeftToMove;
            this.bytesBeingMoved = bytesBeingMoved;
            this.bytesAlreadyMoved = bytesAlreadyMoved;
        }

        void print(int iteration, PrintStream out) {
            out.printf("%-24s %10d  %19s  %18s  %17s%n", DateFormat.getDateTimeInstance().format(new Date()), iteration, StringUtils.byteDesc(this.bytesAlreadyMoved), StringUtils.byteDesc(this.bytesLeftToMove), StringUtils.byteDesc(this.bytesBeingMoved));
        }
    }
}

