/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.top;

import com.facebook.presto.hadoop.$internal.com.google.common.base.Preconditions;
import com.facebook.presto.hadoop.$internal.com.google.common.primitives.Ints;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSConfigKeys;

@InterfaceAudience.Private
public final class TopConf {
    public final boolean isEnabled;
    public static final String ALL_CMDS = "*";
    public final int[] nntopReportingPeriodsMs;

    public TopConf(Configuration conf) {
        this.isEnabled = conf.getBoolean("dfs.namenode.top.enabled", true);
        String[] periodsStr = conf.getTrimmedStrings("dfs.namenode.top.windows.minutes", DFSConfigKeys.NNTOP_WINDOWS_MINUTES_DEFAULT);
        this.nntopReportingPeriodsMs = new int[periodsStr.length];
        for (int i = 0; i < periodsStr.length; ++i) {
            this.nntopReportingPeriodsMs[i] = Ints.checkedCast(TimeUnit.MINUTES.toMillis(Integer.parseInt(periodsStr[i])));
        }
        for (int aPeriodMs : this.nntopReportingPeriodsMs) {
            Preconditions.checkArgument((long)aPeriodMs >= TimeUnit.MINUTES.toMillis(1L), "minimum reporting period is 1 min!");
        }
    }
}

