/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.client;

import com.facebook.presto.jdbc.internal.client.ClientTypeSignature;
import com.facebook.presto.jdbc.internal.com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.presto.jdbc.internal.common.type.BigintEnumType;
import com.facebook.presto.jdbc.internal.common.type.DistinctTypeInfo;
import com.facebook.presto.jdbc.internal.common.type.NamedTypeSignature;
import com.facebook.presto.jdbc.internal.common.type.ParameterKind;
import com.facebook.presto.jdbc.internal.common.type.TypeSignatureParameter;
import com.facebook.presto.jdbc.internal.common.type.VarcharEnumType;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.jackson.core.JsonParser;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationContext;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonNode;
import com.facebook.presto.jdbc.internal.jackson.databind.ObjectMapper;
import com.facebook.presto.jdbc.internal.jackson.databind.annotation.JsonDeserialize;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import java.io.IOException;
import java.util.Objects;

@JsonDeserialize(using=ClientTypeSignatureParameterDeserializer.class)
@Immutable
public class ClientTypeSignatureParameter {
    private final ParameterKind kind;
    private final Object value;

    public ClientTypeSignatureParameter(TypeSignatureParameter typeParameterSignature) {
        this.kind = typeParameterSignature.getKind();
        switch (this.kind) {
            case TYPE: {
                this.value = new ClientTypeSignature(typeParameterSignature.getTypeSignature());
                break;
            }
            case LONG: {
                this.value = typeParameterSignature.getLongLiteral();
                break;
            }
            case NAMED_TYPE: {
                this.value = typeParameterSignature.getNamedTypeSignature();
                break;
            }
            case LONG_ENUM: {
                this.value = typeParameterSignature.getLongEnumMap();
                break;
            }
            case VARCHAR_ENUM: {
                this.value = typeParameterSignature.getVarcharEnumMap();
                break;
            }
            case DISTINCT_TYPE: {
                this.value = typeParameterSignature.getDistinctTypeInfo();
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unknown kind [%s]", new Object[]{this.kind}));
            }
        }
    }

    @JsonCreator
    public ClientTypeSignatureParameter(@JsonProperty(value="kind") ParameterKind kind, @JsonProperty(value="value") Object value) {
        this.kind = kind;
        this.value = value;
    }

    @JsonProperty
    public ParameterKind getKind() {
        return this.kind;
    }

    @JsonProperty
    public Object getValue() {
        return this.value;
    }

    private <A> A getValue(ParameterKind expectedParameterKind, Class<A> target) {
        if (this.kind != expectedParameterKind) {
            throw new IllegalArgumentException(String.format("ParameterKind is [%s] but expected [%s]", new Object[]{this.kind, expectedParameterKind}));
        }
        return target.cast(this.value);
    }

    public ClientTypeSignature getTypeSignature() {
        return this.getValue(ParameterKind.TYPE, ClientTypeSignature.class);
    }

    public Long getLongLiteral() {
        return this.getValue(ParameterKind.LONG, Long.class);
    }

    public NamedTypeSignature getNamedTypeSignature() {
        return this.getValue(ParameterKind.NAMED_TYPE, NamedTypeSignature.class);
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientTypeSignatureParameter other = (ClientTypeSignatureParameter)o;
        return Objects.equals((Object)this.kind, (Object)other.kind) && Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.value});
    }

    public static class ClientTypeSignatureParameterDeserializer
    extends JsonDeserializer<ClientTypeSignatureParameter> {
        private static final ObjectMapper MAPPER = new JsonObjectMapperProvider().get();

        @Override
        public ClientTypeSignatureParameter deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
            Object value;
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            ParameterKind kind = MAPPER.readValue(MAPPER.treeAsTokens(node.get("kind")), ParameterKind.class);
            JsonParser jsonValue = MAPPER.treeAsTokens(node.get("value"));
            switch (kind) {
                case TYPE: {
                    value = MAPPER.readValue(jsonValue, ClientTypeSignature.class);
                    break;
                }
                case NAMED_TYPE: {
                    value = MAPPER.readValue(jsonValue, NamedTypeSignature.class);
                    break;
                }
                case LONG: {
                    value = MAPPER.readValue(jsonValue, Long.class);
                    break;
                }
                case LONG_ENUM: {
                    value = MAPPER.readValue(jsonValue, BigintEnumType.LongEnumMap.class);
                    break;
                }
                case VARCHAR_ENUM: {
                    value = MAPPER.readValue(jsonValue, VarcharEnumType.VarcharEnumMap.class);
                    break;
                }
                case DISTINCT_TYPE: {
                    value = MAPPER.readValue(jsonValue, DistinctTypeInfo.class);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported kind [%s]", new Object[]{kind}));
                }
            }
            return new ClientTypeSignatureParameter(kind, value);
        }
    }
}

