/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.block.AbstractRowBlock;
import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockUtil;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.javax.annotation.Nullable;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ObjLongConsumer;

public class RowBlock
extends AbstractRowBlock
implements Block {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(RowBlock.class).instanceSize();
    private final int startOffset;
    private final int positionCount;
    @Nullable
    private final boolean[] rowIsNull;
    private final int[] fieldBlockOffsets;
    private final Block[] fieldBlocks;
    private final long retainedSizeInBytes;
    private volatile long sizeInBytes;
    private volatile long logicalSizeInBytes;

    public static Block fromFieldBlocks(int positionCount, Optional<boolean[]> rowIsNullOptional, Block[] fieldBlocks) {
        boolean[] rowIsNull = rowIsNullOptional.orElse(null);
        int[] fieldBlockOffsets = new int[positionCount + 1];
        if (rowIsNull == null) {
            for (int position = 0; position < fieldBlockOffsets.length; ++position) {
                fieldBlockOffsets[position] = position;
            }
        } else {
            int currentOffset = 0;
            for (int position = 0; position < positionCount; ++position) {
                fieldBlockOffsets[position] = currentOffset;
                currentOffset += rowIsNull[position] ? 0 : 1;
            }
            fieldBlockOffsets[positionCount] = currentOffset;
            if (currentOffset == positionCount) {
                rowIsNull = null;
            }
        }
        RowBlock.validateConstructorArguments(0, positionCount, rowIsNull, fieldBlockOffsets, fieldBlocks);
        return new RowBlock(0, positionCount, rowIsNull, fieldBlockOffsets, fieldBlocks);
    }

    static RowBlock createRowBlockInternal(int startOffset, int positionCount, @Nullable boolean[] rowIsNull, int[] fieldBlockOffsets, Block[] fieldBlocks) {
        RowBlock.validateConstructorArguments(startOffset, positionCount, rowIsNull, fieldBlockOffsets, fieldBlocks);
        return new RowBlock(startOffset, positionCount, rowIsNull, fieldBlockOffsets, fieldBlocks);
    }

    private static void validateConstructorArguments(int startOffset, int positionCount, @Nullable boolean[] rowIsNull, int[] fieldBlockOffsets, Block[] fieldBlocks) {
        if (startOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        if (rowIsNull != null && rowIsNull.length - startOffset < positionCount) {
            throw new IllegalArgumentException("rowIsNull length is less than positionCount");
        }
        Objects.requireNonNull(fieldBlockOffsets, "fieldBlockOffsets is null");
        if (fieldBlockOffsets.length - startOffset < positionCount + 1) {
            throw new IllegalArgumentException("fieldBlockOffsets length is less than positionCount");
        }
        Objects.requireNonNull(fieldBlocks, "fieldBlocks is null");
        if (fieldBlocks.length <= 0) {
            throw new IllegalArgumentException("Number of fields in RowBlock must be positive");
        }
        int firstFieldBlockPositionCount = fieldBlocks[0].getPositionCount();
        for (int i = 1; i < fieldBlocks.length; ++i) {
            if (firstFieldBlockPositionCount == fieldBlocks[i].getPositionCount()) continue;
            throw new IllegalArgumentException(String.format("length of field blocks differ: field 0: %s, block %s: %s", firstFieldBlockPositionCount, i, fieldBlocks[i].getPositionCount()));
        }
    }

    private RowBlock(int startOffset, int positionCount, @Nullable boolean[] rowIsNull, int[] fieldBlockOffsets, Block[] fieldBlocks) {
        super(fieldBlocks.length);
        this.startOffset = startOffset;
        this.positionCount = positionCount;
        this.rowIsNull = rowIsNull;
        this.fieldBlockOffsets = fieldBlockOffsets;
        this.fieldBlocks = fieldBlocks;
        this.sizeInBytes = -1L;
        this.logicalSizeInBytes = -1L;
        long retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf(fieldBlockOffsets) + SizeOf.sizeOf(rowIsNull);
        for (Block fieldBlock : fieldBlocks) {
            retainedSizeInBytes += fieldBlock.getRetainedSizeInBytes();
        }
        this.retainedSizeInBytes = retainedSizeInBytes;
    }

    @Override
    protected Block[] getRawFieldBlocks() {
        return this.fieldBlocks;
    }

    @Override
    protected int[] getFieldBlockOffsets() {
        return this.fieldBlockOffsets;
    }

    @Override
    public int getOffsetBase() {
        return this.startOffset;
    }

    @Override
    @Nullable
    protected boolean[] getRowIsNull() {
        return this.rowIsNull;
    }

    @Override
    public boolean mayHaveNull() {
        return this.rowIsNull != null;
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.rowIsNull != null && this.rowIsNull[position + this.startOffset];
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        if (this.sizeInBytes < 0L) {
            this.calculateSize();
        }
        return this.sizeInBytes;
    }

    @Override
    public long getLogicalSizeInBytes() {
        if (this.logicalSizeInBytes < 0L) {
            this.calculateLogicalSize();
        }
        return this.logicalSizeInBytes;
    }

    private void calculateSize() {
        int startFieldBlockOffset = this.fieldBlockOffsets[this.startOffset];
        int endFieldBlockOffset = this.fieldBlockOffsets[this.startOffset + this.positionCount];
        int fieldBlockLength = endFieldBlockOffset - startFieldBlockOffset;
        long sizeInBytes = 5L * (long)this.positionCount;
        for (int i = 0; i < this.numFields; ++i) {
            sizeInBytes += this.fieldBlocks[i].getRegionSizeInBytes(startFieldBlockOffset, fieldBlockLength);
        }
        this.sizeInBytes = sizeInBytes;
    }

    private void calculateLogicalSize() {
        int startFieldBlockOffset = this.fieldBlockOffsets[this.startOffset];
        int endFieldBlockOffset = this.fieldBlockOffsets[this.startOffset + this.positionCount];
        int fieldBlockLength = endFieldBlockOffset - startFieldBlockOffset;
        long sizeInBytes = 5L * (long)this.positionCount;
        for (int i = 0; i < this.numFields; ++i) {
            sizeInBytes += this.fieldBlocks[i].getRegionLogicalSizeInBytes(startFieldBlockOffset, fieldBlockLength);
        }
        this.logicalSizeInBytes = sizeInBytes;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        for (int i = 0; i < this.numFields; ++i) {
            consumer.accept(this.fieldBlocks[i], this.fieldBlocks[i].getRetainedSizeInBytes());
        }
        consumer.accept(this.fieldBlockOffsets, SizeOf.sizeOf(this.fieldBlockOffsets));
        if (this.rowIsNull != null) {
            consumer.accept(this.rowIsNull, SizeOf.sizeOf(this.rowIsNull));
        }
        consumer.accept(this, INSTANCE_SIZE);
    }

    public String toString() {
        return String.format("RowBlock(%d){numFields=%d, positionCount=%d}", this.hashCode(), this.numFields, this.getPositionCount());
    }

    @Override
    public Block getLoadedBlock() {
        Block[] loadedFieldBlocks = BlockUtil.ensureBlocksAreLoaded(this.fieldBlocks);
        if (loadedFieldBlocks == this.fieldBlocks) {
            return this;
        }
        return RowBlock.createRowBlockInternal(this.startOffset, this.positionCount, this.rowIsNull, this.fieldBlockOffsets, loadedFieldBlocks);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RowBlock other = (RowBlock)obj;
        return this.startOffset == other.startOffset && this.positionCount == other.positionCount && Arrays.equals(this.rowIsNull, other.rowIsNull) && Arrays.equals(this.fieldBlockOffsets, other.fieldBlockOffsets) && Arrays.equals(this.fieldBlocks, other.fieldBlocks) && this.retainedSizeInBytes == other.retainedSizeInBytes;
    }

    public int hashCode() {
        return Objects.hash(this.startOffset, this.positionCount, Arrays.hashCode(this.rowIsNull), Arrays.hashCode(this.fieldBlockOffsets), Arrays.hashCode(this.fieldBlocks), this.retainedSizeInBytes);
    }
}

