/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.io;

import com.facebook.presto.jdbc.internal.common.io.DataOutput;
import com.facebook.presto.jdbc.internal.common.io.DataSink;
import com.facebook.presto.jdbc.internal.io.airlift.slice.OutputStreamSliceOutput;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;

public class OutputStreamDataSink
implements DataSink {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(OutputStreamDataSink.class).instanceSize();
    private final OutputStreamSliceOutput output;

    public OutputStreamDataSink(OutputStream outputStream) {
        this.output = new OutputStreamSliceOutput(Objects.requireNonNull(outputStream, "outputStream is null"));
    }

    @Override
    public long size() {
        return this.output.longSize();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.output.getRetainedSize();
    }

    @Override
    public void write(List<DataOutput> outputData) {
        outputData.forEach(data -> data.writeData(this.output));
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }
}

