/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.function.SqlFunctionProperties;
import com.facebook.presto.jdbc.internal.common.type.AbstractLongType;
import com.facebook.presto.jdbc.internal.common.type.DateTimeEncoding;
import com.facebook.presto.jdbc.internal.common.type.SqlTimestampWithTimeZone;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;

public final class TimestampWithTimeZoneType
extends AbstractLongType {
    public static final TimestampWithTimeZoneType TIMESTAMP_WITH_TIME_ZONE = new TimestampWithTimeZoneType();

    private TimestampWithTimeZoneType() {
        super(TypeSignature.parseTypeSignature("timestamp with time zone"));
    }

    @Override
    public boolean equalValuesAreIdentical() {
        return false;
    }

    @Override
    public Object getObjectValue(SqlFunctionProperties properties, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return new SqlTimestampWithTimeZone(block.getLong(position));
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        long rightValue;
        long leftValue = DateTimeEncoding.unpackMillisUtc(leftBlock.getLong(leftPosition));
        return leftValue == (rightValue = DateTimeEncoding.unpackMillisUtc(rightBlock.getLong(rightPosition)));
    }

    @Override
    public long hash(Block block, int position) {
        return AbstractLongType.hash(DateTimeEncoding.unpackMillisUtc(block.getLong(position)));
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        long leftValue = DateTimeEncoding.unpackMillisUtc(leftBlock.getLong(leftPosition));
        long rightValue = DateTimeEncoding.unpackMillisUtc(rightBlock.getLong(rightPosition));
        return Long.compare(leftValue, rightValue);
    }

    @Override
    public boolean equals(Object other) {
        return other == TIMESTAMP_WITH_TIME_ZONE;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

