/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.common.predicate.TupleDomain;
import com.facebook.presto.jdbc.internal.spi.SchemaTableName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MaterializedViewStatus {
    private final MaterializedViewState materializedViewState;
    private final Map<SchemaTableName, MaterializedDataPredicates> partitionsFromBaseTables;

    public MaterializedViewStatus(MaterializedViewState materializedViewState) {
        this(materializedViewState, Collections.emptyMap());
    }

    public MaterializedViewStatus(MaterializedViewState materializedViewState, Map<SchemaTableName, MaterializedDataPredicates> partitionsFromBaseTables) {
        this.materializedViewState = Objects.requireNonNull(materializedViewState, "materializedViewState is null");
        this.partitionsFromBaseTables = Objects.requireNonNull(partitionsFromBaseTables, "partitionsFromBaseTables is null");
    }

    public MaterializedViewState getMaterializedViewState() {
        return this.materializedViewState;
    }

    public boolean isFullyMaterialized() {
        return this.materializedViewState == MaterializedViewState.FULLY_MATERIALIZED;
    }

    public boolean isNotMaterialized() {
        return this.materializedViewState == MaterializedViewState.NOT_MATERIALIZED;
    }

    public boolean isTooManyPartitionsMissing() {
        return this.materializedViewState == MaterializedViewState.TOO_MANY_PARTITIONS_MISSING;
    }

    public boolean isPartiallyMaterialized() {
        return this.materializedViewState == MaterializedViewState.PARTIALLY_MATERIALIZED;
    }

    public Map<SchemaTableName, MaterializedDataPredicates> getPartitionsFromBaseTables() {
        return this.partitionsFromBaseTables;
    }

    public static class MaterializedDataPredicates {
        private final List<TupleDomain<String>> predicateDisjuncts;
        private final List<String> columnNames;

        public MaterializedDataPredicates(List<TupleDomain<String>> predicateDisjuncts, List<String> keys) {
            this.predicateDisjuncts = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(predicateDisjuncts, "partitionSpecs is null")));
            this.columnNames = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(keys, "keys is null")));
        }

        public boolean isEmpty() {
            return this.predicateDisjuncts.isEmpty();
        }

        public List<TupleDomain<String>> getPredicateDisjuncts() {
            return this.predicateDisjuncts;
        }

        public List<String> getColumnNames() {
            return this.columnNames;
        }
    }

    public static enum MaterializedViewState {
        NOT_MATERIALIZED,
        TOO_MANY_PARTITIONS_MISSING,
        PARTIALLY_MATERIALIZED,
        FULLY_MATERIALIZED;

    }
}

