/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.common.Utils;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.plan.PartitioningHandle;
import com.facebook.presto.jdbc.internal.spi.plan.PartitioningScheme;
import com.facebook.presto.jdbc.internal.spi.plan.PlanFragmentId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.StageExecutionDescriptor;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class SimplePlanFragment {
    private final PlanFragmentId id;
    private final PlanNode root;
    private final Set<VariableReferenceExpression> variables;
    private final PartitioningHandle partitioning;
    private final List<PlanNodeId> tableScanSchedulingOrder;
    private final PartitioningScheme partitioningScheme;
    private final StageExecutionDescriptor stageExecutionDescriptor;
    private final boolean outputTableWriterFragment;

    @JsonCreator
    public SimplePlanFragment(@JsonProperty(value="id") PlanFragmentId id, @JsonProperty(value="root") PlanNode root, @JsonProperty(value="variables") Set<VariableReferenceExpression> variables, @JsonProperty(value="partitioning") PartitioningHandle partitioning, @JsonProperty(value="tableScanSchedulingOrder") List<PlanNodeId> tableScanSchedulingOrder, @JsonProperty(value="partitioningScheme") PartitioningScheme partitioningScheme, @JsonProperty(value="stageExecutionDescriptor") StageExecutionDescriptor stageExecutionDescriptor, @JsonProperty(value="outputTableWriterFragment") boolean outputTableWriterFragment) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.root = Objects.requireNonNull(root, "root is null");
        this.variables = Objects.requireNonNull(variables, "variables is null");
        this.partitioning = Objects.requireNonNull(partitioning, "partitioning is null");
        Objects.requireNonNull(tableScanSchedulingOrder, "tableScanSchedulingOrder is null");
        this.tableScanSchedulingOrder = Collections.unmodifiableList(new ArrayList<PlanNodeId>(tableScanSchedulingOrder));
        this.stageExecutionDescriptor = Objects.requireNonNull(stageExecutionDescriptor, "stageExecutionDescriptor is null");
        this.outputTableWriterFragment = outputTableWriterFragment;
        Objects.requireNonNull(partitioningScheme, "partitioningScheme is null");
        Utils.checkArgument(new HashSet<VariableReferenceExpression>(root.getOutputVariables()).containsAll(partitioningScheme.getOutputLayout()), String.format("Root node outputs (%s) does not include all fragment outputs (%s)", root.getOutputVariables(), partitioningScheme.getOutputLayout()));
        this.partitioningScheme = partitioningScheme;
    }

    @JsonProperty
    public PlanFragmentId getId() {
        return this.id;
    }

    @JsonProperty
    public PlanNode getRoot() {
        return this.root;
    }

    @JsonProperty
    public Set<VariableReferenceExpression> getVariables() {
        return this.variables;
    }

    @JsonProperty
    public PartitioningHandle getPartitioning() {
        return this.partitioning;
    }

    @JsonProperty
    public List<PlanNodeId> getTableScanSchedulingOrder() {
        return this.tableScanSchedulingOrder;
    }

    @JsonProperty
    public PartitioningScheme getPartitioningScheme() {
        return this.partitioningScheme;
    }

    @JsonProperty
    public StageExecutionDescriptor getStageExecutionDescriptor() {
        return this.stageExecutionDescriptor;
    }

    @JsonProperty
    public boolean isOutputTableWriterFragment() {
        return this.outputTableWriterFragment;
    }
}

