/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.common.Utils;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class StageExecutionDescriptor {
    private final StageExecutionStrategy stageExecutionStrategy;
    private final Set<PlanNodeId> groupedExecutionScanNodes;
    private final int totalLifespans;

    private StageExecutionDescriptor(StageExecutionStrategy stageExecutionStrategy, Set<PlanNodeId> groupedExecutionScanNodes, int totalLifespans) {
        switch (stageExecutionStrategy) {
            case UNGROUPED_EXECUTION: {
                Utils.checkArgument(groupedExecutionScanNodes.isEmpty(), "groupedExecutionScanNodes must be empty if stage execution strategy is ungrouped execution");
                break;
            }
            case FIXED_LIFESPAN_SCHEDULE_GROUPED_EXECUTION: 
            case DYNAMIC_LIFESPAN_SCHEDULE_GROUPED_EXECUTION: 
            case RECOVERABLE_GROUPED_EXECUTION: {
                Utils.checkArgument(!groupedExecutionScanNodes.isEmpty(), "groupedExecutionScanNodes cannot be empty if stage execution strategy is grouped execution");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported stage execution strategy: " + (Object)((Object)stageExecutionStrategy));
            }
        }
        this.stageExecutionStrategy = Objects.requireNonNull(stageExecutionStrategy, "stageExecutionStrategy is null");
        this.groupedExecutionScanNodes = Objects.requireNonNull(groupedExecutionScanNodes, "groupedExecutionScanNodes is null");
        this.totalLifespans = totalLifespans;
    }

    public static StageExecutionDescriptor ungroupedExecution() {
        return new StageExecutionDescriptor(StageExecutionStrategy.UNGROUPED_EXECUTION, Collections.emptySet(), 1);
    }

    public static StageExecutionDescriptor fixedLifespanScheduleGroupedExecution(List<PlanNodeId> capableScanNodes, int totalLifespans) {
        Objects.requireNonNull(capableScanNodes, "capableScanNodes is null");
        Utils.checkArgument(!capableScanNodes.isEmpty(), "capableScanNodes cannot be empty if stage execution strategy is grouped execution");
        return new StageExecutionDescriptor(StageExecutionStrategy.FIXED_LIFESPAN_SCHEDULE_GROUPED_EXECUTION, Collections.unmodifiableSet(new HashSet<PlanNodeId>(capableScanNodes)), totalLifespans);
    }

    public static StageExecutionDescriptor dynamicLifespanScheduleGroupedExecution(List<PlanNodeId> capableScanNodes, int totalLifespans) {
        Objects.requireNonNull(capableScanNodes, "capableScanNodes is null");
        Utils.checkArgument(!capableScanNodes.isEmpty(), "capableScanNodes cannot be empty if stage execution strategy is grouped execution");
        return new StageExecutionDescriptor(StageExecutionStrategy.DYNAMIC_LIFESPAN_SCHEDULE_GROUPED_EXECUTION, Collections.unmodifiableSet(new HashSet<PlanNodeId>(capableScanNodes)), totalLifespans);
    }

    public static StageExecutionDescriptor recoverableGroupedExecution(List<PlanNodeId> capableScanNodes, int totalLifespans) {
        Objects.requireNonNull(capableScanNodes, "capableScanNodes is null");
        Utils.checkArgument(!capableScanNodes.isEmpty(), "capableScanNodes cannot be empty if stage execution strategy is grouped execution");
        return new StageExecutionDescriptor(StageExecutionStrategy.RECOVERABLE_GROUPED_EXECUTION, Collections.unmodifiableSet(new HashSet<PlanNodeId>(capableScanNodes)), totalLifespans);
    }

    public StageExecutionStrategy getStageExecutionStrategy() {
        return this.stageExecutionStrategy;
    }

    public boolean isStageGroupedExecution() {
        return this.stageExecutionStrategy != StageExecutionStrategy.UNGROUPED_EXECUTION;
    }

    public boolean isDynamicLifespanSchedule() {
        return this.stageExecutionStrategy == StageExecutionStrategy.DYNAMIC_LIFESPAN_SCHEDULE_GROUPED_EXECUTION || this.stageExecutionStrategy == StageExecutionStrategy.RECOVERABLE_GROUPED_EXECUTION;
    }

    public boolean isScanGroupedExecution(PlanNodeId scanNodeId) {
        return this.groupedExecutionScanNodes.contains(scanNodeId);
    }

    public boolean isRecoverableGroupedExecution() {
        return this.stageExecutionStrategy == StageExecutionStrategy.RECOVERABLE_GROUPED_EXECUTION;
    }

    @JsonCreator
    public static StageExecutionDescriptor jsonCreator(@JsonProperty(value="stageExecutionStrategy") StageExecutionStrategy stageExecutionStrategy, @JsonProperty(value="groupedExecutionScanNodes") Set<PlanNodeId> groupedExecutionCapableScanNodes, @JsonProperty(value="totalLifespans") int totalLifespans) {
        return new StageExecutionDescriptor(Objects.requireNonNull(stageExecutionStrategy, "stageExecutionStrategy is null"), Collections.unmodifiableSet(Objects.requireNonNull(groupedExecutionCapableScanNodes, "groupedExecutionScanNodes is null")), totalLifespans);
    }

    @JsonProperty(value="stageExecutionStrategy")
    public StageExecutionStrategy getJsonSerializableStageExecutionStrategy() {
        return this.stageExecutionStrategy;
    }

    @JsonProperty(value="groupedExecutionScanNodes")
    public Set<PlanNodeId> getJsonSerializableGroupedExecutionScanNodes() {
        return this.groupedExecutionScanNodes;
    }

    @JsonProperty(value="totalLifespans")
    public int getTotalLifespans() {
        return this.totalLifespans;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StageExecutionDescriptor other = (StageExecutionDescriptor)o;
        return Objects.equals((Object)this.stageExecutionStrategy, (Object)other.stageExecutionStrategy) && Objects.equals(this.groupedExecutionScanNodes, other.groupedExecutionScanNodes) && this.totalLifespans == other.totalLifespans;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.stageExecutionStrategy, this.groupedExecutionScanNodes, this.totalLifespans});
    }

    public String toString() {
        String sb = "StageExecutionDescriptor{stageExecutionStrategy=" + (Object)((Object)this.stageExecutionStrategy) + ", groupedExecutionScanNodes=" + this.groupedExecutionScanNodes + ", totalLifespans=" + this.totalLifespans + '}';
        return sb;
    }

    public static enum StageExecutionStrategy {
        UNGROUPED_EXECUTION,
        FIXED_LIFESPAN_SCHEDULE_GROUPED_EXECUTION,
        DYNAMIC_LIFESPAN_SCHEDULE_GROUPED_EXECUTION,
        RECOVERABLE_GROUPED_EXECUTION;

    }
}

