/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.statistics;

import com.facebook.presto.jdbc.internal.spi.statistics.ColumnStatisticMetadata;
import com.facebook.presto.jdbc.internal.spi.statistics.TableStatisticType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class TableStatisticsMetadata {
    private static final TableStatisticsMetadata EMPTY_STATISTICS_METADATA = new TableStatisticsMetadata(Collections.emptySet(), Collections.emptySet(), Collections.emptyList());
    private final Set<ColumnStatisticMetadata> columnStatistics;
    private final Set<TableStatisticType> tableStatistics;
    private final List<String> groupingColumns;

    public static TableStatisticsMetadata empty() {
        return EMPTY_STATISTICS_METADATA;
    }

    public TableStatisticsMetadata(Set<ColumnStatisticMetadata> columnStatistics, Set<TableStatisticType> tableStatistics, List<String> groupingColumns) {
        this.columnStatistics = Collections.unmodifiableSet(new LinkedHashSet(Objects.requireNonNull(columnStatistics, "columnStatistics is null")));
        this.tableStatistics = Collections.unmodifiableSet(new LinkedHashSet(Objects.requireNonNull(tableStatistics, "tableStatistics is null")));
        this.groupingColumns = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(groupingColumns, "groupingColumns is null")));
    }

    public Set<ColumnStatisticMetadata> getColumnStatistics() {
        return this.columnStatistics;
    }

    public Set<TableStatisticType> getTableStatistics() {
        return this.tableStatistics;
    }

    public List<String> getGroupingColumns() {
        return this.groupingColumns;
    }

    public boolean isEmpty() {
        return this.tableStatistics.isEmpty() && this.columnStatistics.isEmpty();
    }
}

