/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.ttl;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.Objects;

public class ConfidenceBasedTtlInfo {
    private final Instant expiryInstant;
    private final Double confidencePercentage;

    @JsonCreator
    public ConfidenceBasedTtlInfo(@JsonProperty(value="expiryEpochTime") long expiryEpochTime, @JsonProperty(value="confidencePercentage") double confidencePercentage) {
        this.expiryInstant = Instant.ofEpochSecond(expiryEpochTime);
        this.confidencePercentage = confidencePercentage;
    }

    public static ConfidenceBasedTtlInfo getInfiniteTtl() {
        return new ConfidenceBasedTtlInfo(Instant.MAX.getEpochSecond(), 100.0);
    }

    @JsonProperty(value="expiryEpochTime")
    public long getExpiryEpochSecond() {
        return this.expiryInstant.getEpochSecond();
    }

    public Instant getExpiryInstant() {
        return this.expiryInstant;
    }

    @JsonProperty
    public Double getConfidencePercentage() {
        return this.confidencePercentage;
    }

    public int hashCode() {
        return Objects.hash(this.expiryInstant, this.confidencePercentage);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConfidenceBasedTtlInfo other = (ConfidenceBasedTtlInfo)obj;
        return this.expiryInstant.equals(other.getExpiryInstant()) && this.confidencePercentage.equals(other.getConfidencePercentage());
    }

    public String toString() {
        return "expiryEpochTimeUTC=" + this.expiryInstant + ", confidencePercentage=" + this.confidencePercentage;
    }
}

