/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.GenericInternalException;
import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.common.block.ShortArrayBlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.UncheckedBlock;
import com.facebook.presto.jdbc.internal.common.function.SqlFunctionProperties;
import com.facebook.presto.jdbc.internal.common.type.AbstractPrimitiveType;
import com.facebook.presto.jdbc.internal.common.type.FixedWidthType;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;

public final class SmallintType
extends AbstractPrimitiveType
implements FixedWidthType {
    public static final SmallintType SMALLINT = new SmallintType();

    private SmallintType() {
        super(TypeSignature.parseTypeSignature("smallint"), Long.TYPE);
    }

    @Override
    public int getFixedSize() {
        return 2;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new ShortArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / 2));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 2);
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new ShortArrayBlockBuilder(null, positionCount);
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public Object getObjectValue(SqlFunctionProperties properties, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return block.getShort(position);
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        short rightValue;
        short leftValue = leftBlock.getShort(leftPosition);
        return leftValue == (rightValue = rightBlock.getShort(rightPosition));
    }

    @Override
    public long hash(Block block, int position) {
        return SmallintType.hash(block.getShort(position));
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        short leftValue = leftBlock.getShort(leftPosition);
        short rightValue = rightBlock.getShort(rightPosition);
        return Short.compare(leftValue, rightValue);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeShort(block.getShort(position)).closeEntry();
        }
    }

    @Override
    public long getLong(Block block, int position) {
        return block.getShort(position);
    }

    @Override
    public long getLongUnchecked(UncheckedBlock block, int internalPosition) {
        return block.getShortUnchecked(internalPosition);
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        if (value > 32767L) {
            throw new GenericInternalException(String.format("Value %d exceeds MAX_SHORT", value));
        }
        if (value < -32768L) {
            throw new GenericInternalException(String.format("Value %d is less than MIN_SHORT", value));
        }
        blockBuilder.writeShort((int)value).closeEntry();
    }

    @Override
    public boolean equals(Object other) {
        return other == SMALLINT;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static long hash(short value) {
        return Long.rotateLeft((long)value * -4417276706812531889L, 31) * -7046029288634856825L;
    }
}

