/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.common.block.Int128ArrayBlockBuilder;
import com.facebook.presto.jdbc.internal.common.function.SqlFunctionProperties;
import com.facebook.presto.jdbc.internal.common.type.AbstractPrimitiveType;
import com.facebook.presto.jdbc.internal.common.type.FixedWidthType;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.io.airlift.slice.XxHash64;
import java.util.UUID;

public class UuidType
extends AbstractPrimitiveType
implements FixedWidthType {
    public static final UuidType UUID = new UuidType();

    private UuidType() {
        super(TypeSignature.parseTypeSignature("uuid"), Slice.class);
    }

    @Override
    public int getFixedSize() {
        return 16;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new Int128ArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / this.getFixedSize()));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getFixedSize());
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new Int128ArrayBlockBuilder(null, positionCount);
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        return leftBlock.getLong(leftPosition, 8) == rightBlock.getLong(rightPosition, 8) && leftBlock.getLong(leftPosition, 0) == rightBlock.getLong(rightPosition, 0);
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        int compare = Long.compare(leftBlock.getLong(leftPosition, 8), rightBlock.getLong(rightPosition, 8));
        if (compare != 0) {
            return compare;
        }
        return Long.compare(leftBlock.getLong(leftPosition, 0), rightBlock.getLong(rightPosition, 0));
    }

    @Override
    public long hash(Block block, int position) {
        return XxHash64.hash(this.getSlice(block, position));
    }

    @Override
    public Object getObjectValue(SqlFunctionProperties sqlFunctionProperties, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return new UUID(Long.reverseBytes(block.getLong(position, 0)), Long.reverseBytes(block.getLong(position, 8))).toString();
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeLong(block.getLong(position, 0));
            blockBuilder.writeLong(block.getLong(position, 8));
            blockBuilder.closeEntry();
        }
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        if (length != 16) {
            throw new IllegalStateException("Expected entry size to be exactly 16 but was " + length);
        }
        blockBuilder.writeLong(value.getLong(offset));
        blockBuilder.writeLong(value.getLong(offset + 8));
        blockBuilder.closeEntry();
    }

    @Override
    public final Slice getSlice(Block block, int position) {
        return Slices.wrappedLongArray(block.getLong(position, 0), block.getLong(position, 8));
    }

    public static Slice javaUuidToPrestoUuid(UUID uuid) {
        return Slices.wrappedLongArray(Long.reverseBytes(uuid.getMostSignificantBits()), Long.reverseBytes(uuid.getLeastSignificantBits()));
    }

    public static UUID prestoUuidToJavaUuid(Slice uuid) {
        if (uuid.length() != 16) {
            throw new IllegalStateException(String.format("Expected value to be exactly %d bytes but was %d", 16, uuid.length()));
        }
        return new UUID(Long.reverseBytes(uuid.getLong(0)), Long.reverseBytes(uuid.getLong(8)));
    }
}

