/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.guava.ser;

import com.facebook.presto.jdbc.internal.guava.collect.Range;
import com.facebook.presto.jdbc.internal.guava.collect.RangeSet;
import com.facebook.presto.jdbc.internal.jackson.core.JsonGenerator;
import com.facebook.presto.jdbc.internal.jackson.databind.BeanProperty;
import com.facebook.presto.jdbc.internal.jackson.databind.JavaType;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonSerializer;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializerProvider;
import com.facebook.presto.jdbc.internal.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import java.util.List;

public class RangeSetSerializer
extends JsonSerializer<RangeSet<Comparable<?>>>
implements ContextualSerializer {
    private JavaType genericRangeListType;

    @Override
    public void serialize(RangeSet<Comparable<?>> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (this.genericRangeListType == null) {
            serializers.findValueSerializer(List.class).serialize(value.asRanges(), gen, serializers);
        } else {
            serializers.findValueSerializer(this.genericRangeListType).serialize(value.asRanges(), gen, serializers);
        }
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) {
        if (property == null) {
            return this;
        }
        RangeSetSerializer serializer = new RangeSetSerializer();
        serializer.genericRangeListType = prov.getTypeFactory().constructCollectionType(List.class, prov.getTypeFactory().constructParametricType(Range.class, property.getType().containedType(0)));
        return serializer;
    }
}

