/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.jdk8;

import com.facebook.presto.jdbc.internal.jackson.core.JsonGenerator;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializerProvider;
import com.facebook.presto.jdbc.internal.jackson.databind.ser.std.StdSerializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.jdk8.WrappedIOException;
import java.io.IOException;
import java.util.stream.IntStream;

public class IntStreamSerializer
extends StdSerializer<IntStream> {
    private static final long serialVersionUID = 1L;
    public static final IntStreamSerializer INSTANCE = new IntStreamSerializer();

    private IntStreamSerializer() {
        super(IntStream.class);
    }

    @Override
    public void serialize(IntStream stream, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        try (IntStream is = stream;){
            jgen.writeStartArray();
            is.forEachOrdered(value -> {
                try {
                    jgen.writeNumber(value);
                }
                catch (IOException e) {
                    throw new WrappedIOException(e);
                }
            });
            jgen.writeEndArray();
        }
        catch (WrappedIOException e) {
            throw e.getCause();
        }
    }
}

