/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.common.RuntimeStats;
import com.facebook.presto.jdbc.internal.common.function.SqlFunctionProperties;
import com.facebook.presto.jdbc.internal.common.type.TimeZoneKey;
import com.facebook.presto.jdbc.internal.spi.WarningCollector;
import com.facebook.presto.jdbc.internal.spi.function.SqlFunctionId;
import com.facebook.presto.jdbc.internal.spi.function.SqlInvokedFunction;
import com.facebook.presto.jdbc.internal.spi.security.ConnectorIdentity;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface ConnectorSession {
    public String getQueryId();

    public Optional<String> getSource();

    default public String getUser() {
        return this.getIdentity().getUser();
    }

    public ConnectorIdentity getIdentity();

    public TimeZoneKey getTimeZoneKey();

    public Locale getLocale();

    public Optional<String> getTraceToken();

    public Optional<String> getClientInfo();

    public Set<String> getClientTags();

    public long getStartTime();

    public SqlFunctionProperties getSqlFunctionProperties();

    public Map<SqlFunctionId, SqlInvokedFunction> getSessionFunctions();

    public <T> T getProperty(String var1, Class<T> var2);

    public Optional<String> getSchema();

    default public boolean isReadConstraints() {
        return false;
    }

    public WarningCollector getWarningCollector();

    public RuntimeStats getRuntimeStats();
}

