/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.constraints;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.constraints.TableConstraint;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class NotNullConstraint<T>
extends TableConstraint<T> {
    public NotNullConstraint(T column) {
        this(Optional.empty(), new LinkedHashSet<T>(Collections.singleton(column)));
    }

    public NotNullConstraint(Optional<String> name, T column) {
        this(name, new LinkedHashSet<T>(Collections.singleton(column)));
    }

    @JsonCreator
    public NotNullConstraint(@JsonProperty(value="name") Optional<String> name, @JsonProperty(value="columns") LinkedHashSet<T> columnNames) {
        super(name, columnNames, true, true, true);
    }

    @Override
    public <T, R> Optional<TableConstraint<R>> rebaseConstraint(Map<T, R> assignments) {
        if (this.getColumns().stream().allMatch(assignments::containsKey)) {
            return Optional.of(new NotNullConstraint<T>(this.getName(), this.getColumns().stream().map(assignments::get).collect(Collectors.toCollection(LinkedHashSet::new))));
        }
        return Optional.empty();
    }
}

