/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.statistics;

import com.facebook.presto.jdbc.internal.common.Utils;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.statistics.ConnectorHistogram;
import com.facebook.presto.jdbc.internal.spi.statistics.Estimate;
import java.util.Objects;

public class UniformDistributionHistogram
implements ConnectorHistogram {
    private static final long INSTANCE_SIZE = ClassLayout.parseClass(UniformDistributionHistogram.class).instanceSize();
    private final double lowValue;
    private final double highValue;

    @JsonCreator
    public UniformDistributionHistogram(@JsonProperty(value="lowValue") double lowValue, @JsonProperty(value="highValue") double highValue) {
        Utils.checkArgument(Double.isNaN(lowValue) || Double.isNaN(highValue) || lowValue <= highValue, "lowValue must be <= highValue", new Object[0]);
        this.lowValue = lowValue;
        this.highValue = highValue;
    }

    @JsonProperty
    public double getLowValue() {
        return this.lowValue;
    }

    @JsonProperty
    public double getHighValue() {
        return this.highValue;
    }

    @Override
    public Estimate cumulativeProbability(double value, boolean inclusive) {
        if (Double.isNaN(this.lowValue) || Double.isNaN(this.highValue) || Double.isNaN(value)) {
            return Estimate.unknown();
        }
        if (value >= this.highValue) {
            return Estimate.of(1.0);
        }
        if (value <= this.lowValue) {
            return Estimate.of(0.0);
        }
        if (Double.isInfinite(this.lowValue) || Double.isInfinite(this.highValue)) {
            return Estimate.unknown();
        }
        return Estimate.of(Math.min(1.0, Math.max(0.0, (value - this.lowValue) / (this.highValue - this.lowValue))));
    }

    @Override
    public Estimate inverseCumulativeProbability(double percentile) {
        Utils.checkArgument(percentile >= 0.0 && percentile <= 1.0, "percentile must be in [0.0, 1.0]: " + percentile, new Object[0]);
        if (Double.isNaN(this.lowValue) || Double.isNaN(this.highValue)) {
            return Estimate.unknown();
        }
        if (percentile == 0.0 && !Double.isInfinite(this.lowValue)) {
            return Estimate.of(this.lowValue);
        }
        if (percentile == 1.0 && !Double.isInfinite(this.highValue)) {
            return Estimate.of(this.highValue);
        }
        if (Double.isInfinite(this.lowValue) || Double.isInfinite(this.highValue)) {
            return Estimate.unknown();
        }
        return Estimate.of(this.lowValue + percentile * (this.highValue - this.lowValue));
    }

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE;
    }

    public String toString() {
        return "UniformDistributionHistogram{lowValue=" + this.lowValue + ", highValue=" + this.highValue + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UniformDistributionHistogram)) {
            return false;
        }
        UniformDistributionHistogram other = (UniformDistributionHistogram)o;
        return UniformDistributionHistogram.equalsOrBothNaN(this.lowValue, other.lowValue) && UniformDistributionHistogram.equalsOrBothNaN(this.highValue, other.highValue);
    }

    public int hashCode() {
        return Objects.hash(this.lowValue, this.highValue);
    }

    private static boolean equalsOrBothNaN(Double first, Double second) {
        return first.equals(second) || Double.isNaN(first) && Double.isNaN(second);
    }
}

