/*
 * Decompiled with CFR 0.152.
 */
package com.freeway.image.combiner.painter;

import com.freeway.image.combiner.element.CombineElement;
import com.freeway.image.combiner.element.TextElement;
import com.freeway.image.combiner.painter.IPainter;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;

public class TextPainter
implements IPainter {
    @Override
    public void draw(Graphics2D g, CombineElement element, int canvasWidth) {
        TextElement textElement = (TextElement)element;
        List<Object> textLineElements = new ArrayList<TextElement>();
        textLineElements.add(textElement);
        if (textElement.isAutoBreakLine()) {
            textLineElements = textElement.getBreakLineElements();
        }
        for (int i = 0; i < textLineElements.size(); ++i) {
            TextElement firstLineElement = (TextElement)textLineElements.get(0);
            TextElement currentLineElement = (TextElement)textLineElements.get(i);
            g.setFont(currentLineElement.getFont());
            g.setColor(currentLineElement.getColor());
            if (currentLineElement.isCenter()) {
                if (i == 0) {
                    currentLineElement.setX((canvasWidth - currentLineElement.getWidth()) / 2);
                } else {
                    switch (textElement.getLineAlign()) {
                        case Left: {
                            currentLineElement.setX(firstLineElement.getX());
                            break;
                        }
                        case Center: {
                            currentLineElement.setX((canvasWidth - currentLineElement.getWidth()) / 2);
                            break;
                        }
                        case Right: {
                            currentLineElement.setX(firstLineElement.getX() + firstLineElement.getWidth() - currentLineElement.getWidth());
                        }
                    }
                }
            } else if (i > 0) {
                switch (textElement.getLineAlign()) {
                    case Left: {
                        currentLineElement.setX(firstLineElement.getX());
                        break;
                    }
                    case Center: {
                        currentLineElement.setX(firstLineElement.getX() + (firstLineElement.getWidth() - currentLineElement.getWidth()) / 2);
                        break;
                    }
                    case Right: {
                        currentLineElement.setX(firstLineElement.getX() + firstLineElement.getWidth() - currentLineElement.getWidth());
                    }
                }
            }
            if (currentLineElement.getRotate() != null) {
                g.rotate(Math.toRadians(currentLineElement.getRotate().intValue()), currentLineElement.getX() + currentLineElement.getWidth() / 2, currentLineElement.getDrawY().intValue());
            }
            g.setComposite(AlphaComposite.getInstance(3, currentLineElement.getAlpha()));
            if (currentLineElement.isStrikeThrough()) {
                AttributedString as = new AttributedString(currentLineElement.getText());
                as.addAttribute(TextAttribute.FONT, currentLineElement.getFont());
                as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON, 0, currentLineElement.getText().length());
                g.drawString(as.getIterator(), currentLineElement.getX(), (int)currentLineElement.getDrawY());
            } else {
                g.drawString(currentLineElement.getText(), currentLineElement.getX(), (int)currentLineElement.getDrawY());
            }
            if (currentLineElement.getRotate() == null) continue;
            g.rotate(-Math.toRadians(currentLineElement.getRotate().intValue()), currentLineElement.getX() + currentLineElement.getWidth() / 2, currentLineElement.getDrawY().intValue());
        }
    }
}

