/*
 * Decompiled with CFR 0.152.
 */
package com.linuxense.javadbf;

public enum DBFDataType {
    UNKNOWN(0),
    CHARACTER(67, 1, 254, 0, true),
    DATE(68, 8, 8, 8, true),
    FLOATING_POINT(70, 1, 20, 0, true),
    LOGICAL(76, 1, 1, 1, true),
    MEMO(77),
    NUMERIC(78, 1, 18, 0, true),
    LONG(73, 4, 4, 4, false),
    CURRENCY(89, 8, 8, 8, false),
    TIMESTAMP(84, 8, 8, 8, false);

    private byte code;
    private int minSize;
    private int maxSize;
    private int defaultSize;
    private boolean writeSupported = false;

    private DBFDataType(byte code) {
        this.code = code;
    }

    private DBFDataType(byte code, int minSize, int maxSize, int defaultSize, boolean writeSupported) {
        this.code = code;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.defaultSize = defaultSize;
        this.writeSupported = writeSupported;
    }

    public byte getCode() {
        return this.code;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getDefaultSize() {
        return this.defaultSize;
    }

    public boolean isWriteSupported() {
        return this.writeSupported;
    }

    public static DBFDataType fromCode(byte cod) {
        for (DBFDataType type : DBFDataType.values()) {
            if (cod != type.code) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown data type:" + cod);
    }
}

