/*
 * Decompiled with CFR 0.152.
 */
package com.linuxense.javadbf;

import com.linuxense.javadbf.DBFCharsetHelper;
import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class DBFHeader {
    public static final byte SIG_DBASE_III = 3;
    private byte signature = (byte)3;
    private byte year;
    private byte month;
    private byte day;
    int numberOfRecords;
    short headerLength;
    short recordLength;
    private short reserv1;
    private byte incompleteTransaction;
    private byte encryptionFlag;
    private int freeRecordThread;
    private int reserv2;
    private int reserv3;
    private byte mdxFlag;
    private byte languageDriver;
    private short reserv4;
    DBFField[] fieldArray;
    private byte terminator1 = (byte)13;
    private Charset detectedCharset;
    private Charset usedCharset;

    protected DBFHeader() {
    }

    void read(DataInput dataInput, Charset charset) throws IOException {
        this.signature = dataInput.readByte();
        this.year = dataInput.readByte();
        this.month = dataInput.readByte();
        this.day = dataInput.readByte();
        this.numberOfRecords = DBFUtils.readLittleEndianInt(dataInput);
        this.headerLength = DBFUtils.readLittleEndianShort(dataInput);
        this.recordLength = DBFUtils.readLittleEndianShort(dataInput);
        this.reserv1 = DBFUtils.readLittleEndianShort(dataInput);
        this.incompleteTransaction = dataInput.readByte();
        this.encryptionFlag = dataInput.readByte();
        this.freeRecordThread = DBFUtils.readLittleEndianInt(dataInput);
        this.reserv2 = dataInput.readInt();
        this.reserv3 = dataInput.readInt();
        this.mdxFlag = dataInput.readByte();
        this.languageDriver = dataInput.readByte();
        this.reserv4 = DBFUtils.readLittleEndianShort(dataInput);
        this.detectedCharset = DBFCharsetHelper.getCharsetByByte(this.languageDriver);
        ArrayList<DBFField> v_fields = new ArrayList<DBFField>();
        this.usedCharset = this.detectedCharset;
        if (charset != null) {
            this.usedCharset = charset;
        }
        if (this.usedCharset == null) {
            this.usedCharset = StandardCharsets.ISO_8859_1;
        }
        DBFField field = null;
        while ((field = DBFField.createField(dataInput, this.usedCharset)) != null) {
            v_fields.add(field);
        }
        this.fieldArray = v_fields.toArray(new DBFField[v_fields.size()]);
    }

    void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.signature);
        Calendar calendar = Calendar.getInstance();
        this.year = (byte)(calendar.get(1) - 1900);
        this.month = (byte)(calendar.get(2) + 1);
        this.day = (byte)calendar.get(5);
        dataOutput.writeByte(this.year);
        dataOutput.writeByte(this.month);
        dataOutput.writeByte(this.day);
        this.numberOfRecords = DBFUtils.littleEndian(this.numberOfRecords);
        dataOutput.writeInt(this.numberOfRecords);
        this.headerLength = this.findHeaderLength();
        dataOutput.writeShort(DBFUtils.littleEndian(this.headerLength));
        this.recordLength = this.sumUpLenghtOfFields();
        dataOutput.writeShort(DBFUtils.littleEndian(this.recordLength));
        dataOutput.writeShort(DBFUtils.littleEndian(this.reserv1));
        dataOutput.writeByte(this.incompleteTransaction);
        dataOutput.writeByte(this.encryptionFlag);
        dataOutput.writeInt(DBFUtils.littleEndian(this.freeRecordThread));
        dataOutput.writeInt(DBFUtils.littleEndian(this.reserv2));
        dataOutput.writeInt(DBFUtils.littleEndian(this.reserv3));
        dataOutput.writeByte(this.mdxFlag);
        dataOutput.writeByte(this.languageDriver);
        dataOutput.writeShort(DBFUtils.littleEndian(this.reserv4));
        for (DBFField field : this.fieldArray) {
            field.write(dataOutput, this.getUsedCharset());
        }
        dataOutput.writeByte(this.terminator1);
    }

    private short findHeaderLength() {
        return (short)(32 + 32 * this.fieldArray.length + 1);
    }

    private short sumUpLenghtOfFields() {
        int sum = 0;
        for (DBFField field : this.fieldArray) {
            sum += field.getFieldLength();
        }
        return (short)(sum + 1);
    }

    public int getYear() {
        return 1900 + this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public Date getLastModificationDate() {
        if (this.year == 0 || this.month == 0 || this.day == 0) {
            return null;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.set(this.year, this.month, this.day, 0, 0, 0);
            calendar.set(14, 0);
            return calendar.getTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Charset getDetectedCharset() {
        return this.detectedCharset;
    }

    protected Charset getUsedCharset() {
        return this.usedCharset;
    }

    protected void setUsedCharset(Charset charset) {
        this.usedCharset = charset;
    }
}

