/*
 * Decompiled with CFR 0.152.
 */
package com.linuxense.javadbf;

import com.linuxense.javadbf.DBFAlignment;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;

public final class DBFUtils {
    private static final CharsetEncoder ASCII_ENCODER = Charset.forName("US-ASCII").newEncoder();

    private DBFUtils() {
        throw new AssertionError((Object)"No instances of this class are allowed");
    }

    public static int readLittleEndianInt(DataInput in) throws IOException {
        int bigEndian = 0;
        for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
            bigEndian |= (in.readUnsignedByte() & 0xFF) << shiftBy;
        }
        return bigEndian;
    }

    public static short readLittleEndianShort(DataInput in) throws IOException {
        int low = in.readUnsignedByte() & 0xFF;
        int high = in.readUnsignedByte();
        return (short)(high << 8 | low);
    }

    public static byte[] removeSpaces(byte[] array) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(array.length);
        for (byte b : array) {
            if (b == 32) continue;
            baos.write(b);
        }
        return baos.toByteArray();
    }

    public static short littleEndian(short value) {
        short num1 = value;
        int mask = 255;
        short num2 = (short)(num1 & mask);
        num2 = (short)(num2 << 8);
        mask = (short)(mask << 8);
        num2 = (short)(num2 | (num1 & mask) >> 8);
        return num2;
    }

    public static int littleEndian(int value) {
        int num1 = value;
        int mask = 255;
        int num2 = 0;
        num2 |= num1 & mask;
        for (int i = 1; i < 4; ++i) {
            num2 <<= 8;
            num2 |= (num1 & (mask <<= 8)) >> 8 * i;
        }
        return num2;
    }

    public static byte[] textPadding(String text, Charset charset, int length) {
        return DBFUtils.textPadding(text, charset, length, DBFAlignment.LEFT, (byte)32);
    }

    public static byte[] textPadding(String text, Charset charset, int length, DBFAlignment alignment, byte paddingByte) {
        byte[] response = new byte[length];
        Arrays.fill(response, paddingByte);
        byte[] stringBytes = text.getBytes(charset);
        if (stringBytes.length > length) {
            return DBFUtils.textPadding(text.substring(0, text.length() - 1), charset, length, alignment, paddingByte);
        }
        int t_offset = 0;
        switch (alignment) {
            case RIGHT: {
                t_offset = length - stringBytes.length;
                break;
            }
            default: {
                t_offset = 0;
            }
        }
        System.arraycopy(stringBytes, 0, response, t_offset, stringBytes.length);
        return response;
    }

    public static byte[] doubleFormating(Number num, Charset charset, int fieldLength, int sizeDecimalPart) {
        return DBFUtils.doubleFormating(num.doubleValue(), charset, fieldLength, sizeDecimalPart);
    }

    public static byte[] doubleFormating(Double doubleNum, Charset charset, int fieldLength, int sizeDecimalPart) {
        int i;
        int sizeWholePart = fieldLength - (sizeDecimalPart > 0 ? sizeDecimalPart + 1 : 0);
        StringBuilder format = new StringBuilder(fieldLength);
        for (i = 0; i < sizeWholePart; ++i) {
            format.append("#");
        }
        if (sizeDecimalPart > 0) {
            format.append(".");
            for (i = 0; i < sizeDecimalPart; ++i) {
                format.append("0");
            }
        }
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(Locale.ENGLISH);
        df.applyPattern(format.toString());
        return DBFUtils.textPadding(df.format(doubleNum).toString(), charset, fieldLength, DBFAlignment.RIGHT, (byte)32);
    }

    public static boolean contains(byte[] array, byte value) {
        if (array != null) {
            for (byte data : array) {
                if (data != value) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPureAscii(String stringToCheck) {
        if (stringToCheck == null) {
            return true;
        }
        return ASCII_ENCODER.canEncode(stringToCheck);
    }

    public static Object toBoolean(byte t_logical) {
        if (t_logical == 89 || t_logical == 121 || t_logical == 84 || t_logical == 116) {
            return Boolean.TRUE;
        }
        if (t_logical == 78 || t_logical == 110 || t_logical == 70 || t_logical == 102) {
            return Boolean.FALSE;
        }
        return null;
    }
}

