/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import lombok.NonNull;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpOaMailService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpBaseResp;
import me.chanjar.weixin.cp.bean.oa.mail.WxCpMailCommonSendRequest;
import me.chanjar.weixin.cp.bean.oa.mail.WxCpMailMeetingSendRequest;
import me.chanjar.weixin.cp.bean.oa.mail.WxCpMailScheduleSendRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxCpOMailServiceImpl
implements WxCpOaMailService {
    private static final Logger log = LoggerFactory.getLogger(WxCpOMailServiceImpl.class);
    private final WxCpService cpService;

    @Override
    public WxCpBaseResp mailCommonSend(@NonNull WxCpMailCommonSendRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return this.mailSend(request.toJson());
    }

    @Override
    public WxCpBaseResp mailScheduleSend(@NonNull WxCpMailScheduleSendRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return this.mailSend(request.toJson());
    }

    @Override
    public WxCpBaseResp mailMeetingSend(@NonNull WxCpMailMeetingSendRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return this.mailSend(request.toJson());
    }

    private WxCpBaseResp mailSend(String request) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/exmail/app/compose_send");
        String responseContent = this.cpService.post(apiUrl, request);
        return WxCpBaseResp.fromJson(responseContent);
    }

    public WxCpOMailServiceImpl(WxCpService cpService) {
        this.cpService = cpService;
    }
}

