/*
 * Decompiled with CFR 0.152.
 */
package com.github.devmix.esb.car.plugin;

import com.github.devmix.esb.car.plugin.builders.ArtifactsListBuilder;
import com.github.devmix.esb.car.plugin.builders.RegistryArtifactsBuilder;
import com.github.devmix.esb.car.plugin.builders.SynapseConfigArtifactsBuilder;
import com.github.devmix.esb.car.plugin.builders.XmlBuilder;
import com.github.devmix.esb.car.plugin.registry.RegistryMediaTypesBundle;
import com.github.devmix.esb.car.plugin.registry.SynapseArtifactTypesBundle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.StringUtils;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;

@Mojo(name="car", defaultPhase=LifecyclePhase.PACKAGE)
public class CarMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.version}", required=true)
    private String version;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private String outputDirectory;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private String targetDir;
    @Parameter(defaultValue="${project.basedir}/src/main/synapse-config", required=false)
    private String synapseConfigDir;
    @Parameter(required=false)
    private String synapseArtifactTypesFile;
    @Parameter(defaultValue="${project.basedir}/src/main/resources", required=false)
    private String registryConfigDir;
    @Parameter(required=false)
    private String registryMediaTypesFile;
    @Parameter(defaultValue="${project.name}", required=true)
    private String applicationName;
    @Parameter(defaultValue="EnterpriseServiceBus", required=true)
    private String serverRole;
    @Parameter(defaultValue="true")
    private boolean registryAllInOneArtifact;
    @Parameter(defaultValue="resources")
    private String registryAllInOneArtifactName;
    @Parameter(defaultValue="${project.name}_${project.version}", required=true)
    private String carName;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private final ArtifactsListBuilder artifactsListBuilder = new ArtifactsListBuilder();

    public void execute() throws MojoFailureException {
        try {
            Files.createDirectories(Paths.get(this.outputDirectory, new String[0]), new FileAttribute[0]);
            RegistryMediaTypesBundle mediaTypesBundle = this.createRegistryMediaTypesBundle();
            SynapseArtifactTypesBundle artifactTypesBundle = this.createSynapseArtifactTypesBundle();
            ((SynapseConfigArtifactsBuilder)((SynapseConfigArtifactsBuilder)((SynapseConfigArtifactsBuilder)((SynapseConfigArtifactsBuilder)((SynapseConfigArtifactsBuilder)((SynapseConfigArtifactsBuilder)SynapseConfigArtifactsBuilder.newInstance().artifactsList(this.artifactsListBuilder)).outputDirectory(this.outputDirectory)).configDir(this.synapseConfigDir)).serverRole(this.serverRole)).version(this.version)).artifactTypes(artifactTypesBundle)).build();
            ((RegistryArtifactsBuilder)((RegistryArtifactsBuilder)((RegistryArtifactsBuilder)((RegistryArtifactsBuilder)((RegistryArtifactsBuilder)((RegistryArtifactsBuilder)RegistryArtifactsBuilder.newInstance().artifactsList(this.artifactsListBuilder)).outputDirectory(this.outputDirectory)).configDir(this.registryConfigDir)).serverRole(this.serverRole)).version(this.version)).allInOne(this.registryAllInOneArtifact).allInOneName(this.registryAllInOneArtifactName).mediaTypes(mediaTypesBundle).artifactTypes(artifactTypesBundle)).build();
            this.createArtifactsXml();
            this.createCar();
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private SynapseArtifactTypesBundle createSynapseArtifactTypesBundle() {
        SynapseArtifactTypesBundle bundle = new SynapseArtifactTypesBundle().putTypes(((Object)((Object)this)).getClass().getResource("/synapse-artifact-types.yaml"));
        if (StringUtils.isNotBlank((String)this.synapseArtifactTypesFile)) {
            bundle.putTypes(this.synapseArtifactTypesFile);
        }
        return bundle;
    }

    private RegistryMediaTypesBundle createRegistryMediaTypesBundle() {
        RegistryMediaTypesBundle bundle = new RegistryMediaTypesBundle().putTypes(((Object)((Object)this)).getClass().getResource("/registry-media-types.yaml"));
        if (StringUtils.isNotBlank((String)this.registryMediaTypesFile)) {
            bundle.putTypes(this.registryMediaTypesFile);
        }
        return bundle;
    }

    private void createCar() throws MojoFailureException {
        File carFile = new File(this.targetDir, this.carName + ".car");
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(carFile);
        archiver.getArchiver().addDirectory(new File(this.outputDirectory));
        try {
            archiver.createArchive(this.session, this.project, this.archive);
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        this.project.getArtifact().setFile(carFile);
    }

    private void createArtifactsXml() throws IOException, XmlBuilder.XmlBuildException {
        XmlBuilder artifactsXml = new XmlBuilder();
        XmlBuilder.Node artifactNode = artifactsXml.node("artifacts").node("artifact").attr("name", this.applicationName).attr("version", this.version).attr("type", "carbon/application").node();
        for (ArtifactsListBuilder.Dependency dependency : this.artifactsListBuilder.ordered()) {
            artifactNode.node("dependency").attr("artifact", dependency.artifactName).attr("version", dependency.version).attr("include", String.valueOf(dependency.include)).attr("serverRole", dependency.serverRole);
        }
        Path artifactsFileName = Paths.get(this.outputDirectory, "artifacts.xml");
        try (FileOutputStream fis = new FileOutputStream(artifactsFileName.toFile());){
            fis.write(artifactsXml.asString().getBytes());
        }
    }
}

