/*
 * Decompiled with CFR 0.152.
 */
package com.github.devmix.esb.car.plugin.builders;

import com.github.devmix.esb.car.plugin.builders.AbstractArtifactsBuilder;
import com.github.devmix.esb.car.plugin.builders.XmlBuilder;
import com.github.devmix.esb.car.plugin.registry.RegistryMediaTypesBundle;
import com.github.devmix.esb.car.plugin.utils.CommonUtils;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.utils.StringUtils;

public final class RegistryArtifactsBuilder
extends AbstractArtifactsBuilder<RegistryArtifactsBuilder> {
    public static final String RESOURCES_TYPE = "registry";
    public static final String REGISTRY_INFO_XML = "registry-info.xml";
    private boolean allInOne;
    private String allInOneName;
    private Map<String, String> artifactsMediaTypes;
    private RegistryMediaTypesBundle mediaTypes;

    private RegistryArtifactsBuilder() {
    }

    public static RegistryArtifactsBuilder newInstance() {
        return new RegistryArtifactsBuilder();
    }

    public RegistryArtifactsBuilder allInOne(boolean allInOne) {
        this.allInOne = allInOne;
        return this;
    }

    public RegistryArtifactsBuilder allInOneName(String allInOneName) {
        this.allInOneName = allInOneName;
        return this;
    }

    public RegistryArtifactsBuilder mediaTypes(RegistryMediaTypesBundle mediaTypes) {
        this.mediaTypes = mediaTypes;
        return this;
    }

    public void build() throws MojoFailureException {
        this.check();
        if (!Files.exists(Paths.get(this.configDir, new String[0]), new LinkOption[0])) {
            return;
        }
        try {
            this.artifactsMediaTypes = this.readArtifactsTypesList();
            if (this.allInOne) {
                this.createAllInOneRegistryArtifacts();
            } else {
                this.createRegistryArtifacts();
            }
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private void createRegistryArtifacts() throws IOException, MojoFailureException {
        Files.createDirectories(Paths.get(this.outputDirectory, new String[0]), new FileAttribute[0]);
        try (DirectoryStream<Path> confStream = Files.newDirectoryStream(Paths.get(this.configDir, new String[0]));){
            for (Path path : confStream) {
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                this.createArtifacts(path);
            }
        }
    }

    private void createArtifacts(Path root) throws IOException, MojoFailureException {
        try (DirectoryStream<Path> artifactsStream = Files.newDirectoryStream(root);){
            for (Path path : artifactsStream) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    this.createArtifacts(path);
                    continue;
                }
                this.createArtifact(path);
            }
        }
    }

    private void createArtifact(Path fromFile) throws IOException, MojoFailureException {
        String fileName = fromFile.getFileName().toString();
        String registryFile = this.registryFileOf(fromFile);
        String name = CommonUtils.removeFileExtension(fileName);
        Path dir = Paths.get(this.outputDirectory, name + "_" + this.version);
        Path resourcesDir = this.resourcesDirOf(dir);
        Path file = Paths.get(resourcesDir.toString(), fileName);
        if (!Files.exists(resourcesDir, new LinkOption[0])) {
            Files.createDirectories(resourcesDir, new FileAttribute[0]);
        }
        Files.copy(fromFile, file, StandardCopyOption.REPLACE_EXISTING);
        this.createArtifactXml(name, dir);
        try {
            String mediaType = this.detectMediaType(registryFile);
            if (StringUtils.isBlank((String)mediaType)) {
                throw new MojoFailureException("Unknown media type for " + registryFile);
            }
            String registryPath = this.registryPathOf(fromFile);
            Path registryInfoFile = Paths.get(dir.toString(), REGISTRY_INFO_XML);
            String xml = new XmlBuilder().node("resources").node("item").node("file").content(fileName).parent().node("path").content("/" + registryPath).parent().node("mediaType").content(mediaType).builder().asString();
            try (FileOutputStream fis = new FileOutputStream(registryInfoFile.toFile());){
                fis.write(xml.getBytes());
            }
        }
        catch (XmlBuilder.XmlBuildException e) {
            throw new MojoFailureException("Can't create registry-info.xml", (Throwable)e);
        }
        this.artifactsList.add(name, this.version, this.serverRole, true, this.artifactTypes.of(RESOURCES_TYPE).getPriority());
    }

    private void createAllInOneRegistryArtifacts() throws IOException, MojoFailureException {
        Path dir = Paths.get(this.outputDirectory, this.allInOneName + "_" + this.version);
        Path registryInfoXml = Paths.get(dir.toString(), REGISTRY_INFO_XML);
        boolean hasArtifacts = false;
        XmlBuilder.Node registryInfoNode = new XmlBuilder().node("resources");
        try (DirectoryStream<Path> confStream = Files.newDirectoryStream(Paths.get(this.configDir, new String[0]));){
            for (Path path : confStream) {
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                hasArtifacts |= this.createAllInOneArtifacts(path, registryInfoNode);
            }
        }
        if (hasArtifacts) {
            this.createArtifactXml(this.allInOneName, dir);
            var6_6 = null;
            try (FileOutputStream fis = new FileOutputStream(registryInfoXml.toFile());){
                try {
                    fis.write(registryInfoNode.builder().asString().getBytes());
                }
                catch (XmlBuilder.XmlBuildException e) {
                    throw new MojoFailureException("Can't create registry-info.xml", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
            this.artifactsList.add(this.allInOneName, this.version, this.serverRole, true, this.artifactTypes.of(RESOURCES_TYPE).getPriority());
        }
    }

    private boolean createAllInOneArtifacts(Path root, XmlBuilder.Node registryInfoNode) throws IOException, MojoFailureException {
        boolean hasArtifacts = false;
        try (DirectoryStream<Path> artifactsStream = Files.newDirectoryStream(root);){
            for (Path path : artifactsStream) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    hasArtifacts |= this.createAllInOneArtifacts(path, registryInfoNode);
                    continue;
                }
                hasArtifacts |= this.createAllInOneArtifact(path, registryInfoNode);
            }
        }
        return hasArtifacts;
    }

    private boolean createAllInOneArtifact(Path fromFile, XmlBuilder.Node registryInfoNode) throws IOException, MojoFailureException {
        String fileName = fromFile.getFileName().toString();
        String registryFile = this.registryFileOf(fromFile);
        Path dir = Paths.get(this.outputDirectory, this.allInOneName + "_" + this.version);
        Path resourcesDir = this.resourcesDirOf(dir);
        Path file = Paths.get(resourcesDir.toString(), fileName);
        if (!Files.exists(resourcesDir, new LinkOption[0])) {
            Files.createDirectories(resourcesDir, new FileAttribute[0]);
        }
        Files.copy(fromFile, file, StandardCopyOption.REPLACE_EXISTING);
        String mediaType = this.detectMediaType(registryFile);
        String registryPath = this.registryPathOf(fromFile);
        registryInfoNode.node("item").node("file").content(fileName).parent().node("path").content("/" + registryPath).parent().node("mediaType").content(mediaType);
        return true;
    }

    private void createArtifactXml(String name, Path dir) throws IOException, MojoFailureException {
        try {
            Path metaFile = Paths.get(dir.toString(), "artifact.xml");
            String xml = new XmlBuilder().node("artifact").attr("name", name).attr("version", this.version).attr("type", this.artifactTypes.of(RESOURCES_TYPE).getType()).attr("serverRole", this.serverRole).node("file").content(REGISTRY_INFO_XML).builder().asString();
            try (FileOutputStream fis = new FileOutputStream(metaFile.toFile());){
                fis.write(xml.getBytes());
            }
        }
        catch (XmlBuilder.XmlBuildException e) {
            throw new MojoFailureException("Can't create artifact.xml", (Throwable)e);
        }
    }

    private Map<String, String> readArtifactsTypesList() throws IOException {
        Path file = Paths.get(this.configDir, "artifacts.list");
        if (!Files.exists(file, new LinkOption[0])) {
            return Collections.emptyMap();
        }
        try (BufferedReader in = new BufferedReader(new FileReader(file.toFile()));){
            String line;
            HashMap<String, String> result = new HashMap<String, String>();
            String type = "";
            while ((line = in.readLine()) != null) {
                if (StringUtils.isBlank((String)line)) continue;
                if ((line = line.trim()).charAt(0) == ':') {
                    type = line.substring(1);
                    continue;
                }
                result.put(line, type);
            }
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
    }

    @Nullable
    private String detectMediaType(String registryFile) {
        String predefined = this.artifactsMediaTypes.get(registryFile);
        if (!StringUtils.isBlank((String)predefined)) {
            return predefined;
        }
        return this.mediaTypes != null ? this.mediaTypes.of(registryFile).getType() : null;
    }

    private String registryFileOf(Path fromFile) {
        return fromFile.toString().substring(this.configDir.length() + 1).replaceAll("\\\\", "/");
    }

    private String registryPathOf(Path fromFile) {
        return this.registryFileOf(fromFile.getParent());
    }

    private Path resourcesDirOf(Path dir) {
        return Paths.get(dir.toString(), "resources");
    }
}

