/*
 * Decompiled with CFR 0.152.
 */
package com.github.devmix.esb.car.plugin.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;

public final class CommonUtils {
    private CommonUtils() {
    }

    public static String extensionOf(String fileName) {
        int dot = fileName.lastIndexOf(".");
        return dot >= 0 ? fileName.substring(dot + 1) : fileName;
    }

    public static String removeFileExtension(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Filename is null");
        }
        int i = fileName.lastIndexOf(".");
        return i == -1 ? fileName : fileName.substring(0, i);
    }

    public static ObjectMapper mapperOf(String fileName) {
        String lowerCase = fileName.toLowerCase();
        if (lowerCase.endsWith(".yaml")) {
            return new ObjectMapper((JsonFactory)new YAMLFactory());
        }
        if (lowerCase.endsWith(".xml")) {
            return new ObjectMapper((JsonFactory)new XmlFactory());
        }
        return new ObjectMapper(new JsonFactory());
    }
}

