/*
 * Decompiled with CFR 0.152.
 */
package openllet.jena;

import java.util.Map;
import openllet.aterm.ATermAppl;
import openllet.core.datatypes.Datatypes;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.QNameProvider;
import openllet.jena.vocabulary.OWL2;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.vocabulary.OWL;

public class JenaUtils {
    public static final Literal XSD_BOOLEAN_TRUE = ResourceFactory.createTypedLiteral((String)Boolean.TRUE.toString(), (RDFDatatype)XSDDatatype.XSDboolean);

    public static ATermAppl makeLiteral(LiteralLabel jenaLiteral) {
        String lexicalValue = jenaLiteral.getLexicalForm();
        String datatypeURI = jenaLiteral.getDatatypeURI();
        ATermAppl literalValue = null;
        literalValue = datatypeURI != null ? ATermUtils.makeTypedLiteral((String)lexicalValue, (String)datatypeURI) : (jenaLiteral.language() != null ? ATermUtils.makePlainLiteral((String)lexicalValue, (String)jenaLiteral.language()) : ATermUtils.makePlainLiteral((String)lexicalValue));
        return literalValue;
    }

    public static ATermAppl makeATerm(RDFNode node) {
        return JenaUtils.makeATerm(node.asNode());
    }

    public static ATermAppl makeATerm(Node node) {
        if (node.isLiteral()) {
            return JenaUtils.makeLiteral(node.getLiteral());
        }
        if (node.isBlank()) {
            return ATermUtils.makeBnode((String)node.getBlankNodeLabel());
        }
        if (node.isURI()) {
            if (node.equals((Object)OWL.Thing.asNode())) {
                return ATermUtils.TOP;
            }
            if (node.equals((Object)OWL.Nothing.asNode())) {
                return ATermUtils.BOTTOM;
            }
            if (node.equals((Object)OWL2.topDataProperty.asNode())) {
                return ATermUtils.TOP_DATA_PROPERTY;
            }
            if (node.equals((Object)OWL2.bottomDataProperty.asNode())) {
                return ATermUtils.BOTTOM_DATA_PROPERTY;
            }
            if (node.equals((Object)OWL2.topObjectProperty.asNode())) {
                return ATermUtils.TOP_OBJECT_PROPERTY;
            }
            if (node.equals((Object)OWL2.bottomObjectProperty.asNode())) {
                return ATermUtils.BOTTOM_OBJECT_PROPERTY;
            }
            return ATermUtils.makeTermAppl((String)node.getURI());
        }
        if (node.isVariable()) {
            return ATermUtils.makeVar((String)node.getName());
        }
        return null;
    }

    public static Node makeGraphLiteral(ATermAppl literal) {
        Node node;
        String lexicalValue = ((ATermAppl)literal.getArgument(0)).getName();
        ATermAppl lang = (ATermAppl)literal.getArgument(1);
        ATermAppl datatype = (ATermAppl)literal.getArgument(2);
        if (datatype.equals((Object)ATermUtils.PLAIN_LITERAL_DATATYPE)) {
            node = lang.equals((Object)ATermUtils.EMPTY) ? NodeFactory.createLiteral((String)lexicalValue) : NodeFactory.createLiteral((String)lexicalValue, (String)lang.getName(), (boolean)false);
        } else if (datatype.equals((Object)Datatypes.XML_LITERAL)) {
            node = NodeFactory.createLiteral((String)lexicalValue, (String)"", (boolean)true);
        } else {
            RDFDatatype type = TypeMapper.getInstance().getTypeByName(datatype.getName());
            node = NodeFactory.createLiteral((String)lexicalValue, (String)"", (RDFDatatype)type);
        }
        return node;
    }

    public static Node makeGraphResource(ATermAppl term) {
        if (ATermUtils.isBnode((ATermAppl)term)) {
            return NodeFactory.createBlankNode((BlankNodeId)new BlankNodeId(((ATermAppl)term.getArgument(0)).getName()));
        }
        if (term.equals((Object)ATermUtils.TOP)) {
            return OWL.Thing.asNode();
        }
        if (term.equals((Object)ATermUtils.BOTTOM)) {
            return OWL.Nothing.asNode();
        }
        if (term.equals((Object)ATermUtils.TOP_DATA_PROPERTY)) {
            return OWL2.topDataProperty.asNode();
        }
        if (term.equals((Object)ATermUtils.BOTTOM_DATA_PROPERTY)) {
            return OWL2.bottomDataProperty.asNode();
        }
        if (term.equals((Object)ATermUtils.TOP_OBJECT_PROPERTY)) {
            return OWL2.topObjectProperty.asNode();
        }
        if (term.equals((Object)ATermUtils.BOTTOM_OBJECT_PROPERTY)) {
            return OWL2.bottomObjectProperty.asNode();
        }
        if (term.getArity() == 0) {
            return NodeFactory.createURI((String)term.getName());
        }
        throw new InternalReasonerException("Invalid term found " + term);
    }

    public static Node makeGraphNode(ATermAppl value) {
        if (ATermUtils.isLiteral((ATermAppl)value)) {
            return JenaUtils.makeGraphLiteral(value);
        }
        return JenaUtils.makeGraphResource(value);
    }

    public static Literal makeLiteral(ATermAppl literal, Model model) {
        return (Literal)model.asRDFNode(JenaUtils.makeGraphLiteral(literal));
    }

    public static Resource makeResource(ATermAppl term, Model model) {
        return (Resource)model.asRDFNode(JenaUtils.makeGraphResource(term));
    }

    public static RDFNode makeRDFNode(ATermAppl term, Model model) {
        return model.asRDFNode(JenaUtils.makeGraphNode(term));
    }

    public static QNameProvider makeQNameProvider(PrefixMapping mapping) {
        QNameProvider qnames = new QNameProvider();
        for (Map.Entry entry : mapping.getNsPrefixMap().entrySet()) {
            String prefix = (String)entry.getKey();
            String uri = (String)entry.getValue();
            qnames.setMapping(prefix, uri);
        }
        return qnames;
    }
}

