/*
 * Decompiled with CFR 0.152.
 */
package openllet.jena;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.KnowledgeBase;
import openllet.core.boxes.rbox.Role;
import openllet.core.utils.iterator.IteratorUtils;
import openllet.jena.JenaUtils;
import openllet.jena.PelletInfGraph;
import openllet.jena.vocabulary.OWL2;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.ReasonerVocabulary;

public class ModelExtractor {
    public static final Predicate<Triple> FILTER_NONE = t -> false;
    private KnowledgeBase _kb;
    private Predicate<Triple> _filter = FILTER_NONE;
    private EnumSet<StatementType> _selector = StatementType.DEFAULT_STATEMENTS;

    public ModelExtractor() {
    }

    public ModelExtractor(Model model) throws ClassCastException {
        this((PelletInfGraph)model.getGraph());
    }

    public ModelExtractor(PelletInfGraph graph) {
        this(graph.getPreparedKB());
    }

    public ModelExtractor(KnowledgeBase kb) {
        this.setKB(kb);
    }

    private void addTriple(List<Triple> triples, Node s, Node p, Node o) {
        Triple triple = Triple.create((Node)s, (Node)p, (Node)o);
        if (!this._filter.test(triple)) {
            triples.add(triple);
        }
    }

    public Model extractClassModel() {
        return this.extractClassModel(ModelFactory.createDefaultModel());
    }

    public Model extractClassModel(Model model) {
        boolean allSubs = this._selector.contains((Object)StatementType.ALL_SUBCLASS);
        boolean jenaDirectSubs = this._selector.contains((Object)StatementType.JENA_DIRECT_SUBCLASS);
        boolean subs = allSubs || jenaDirectSubs || this._selector.contains((Object)StatementType.DIRECT_SUBCLASS);
        boolean equivs = this._selector.contains((Object)StatementType.EQUIVALENT_CLASS);
        boolean disjs = this._selector.contains((Object)StatementType.DISJOINT_CLASS);
        boolean comps = this._selector.contains((Object)StatementType.COMPLEMENT_CLASS);
        if (subs || equivs || disjs || comps) {
            this._kb.classify();
        }
        ArrayList<Triple> triples = new ArrayList<Triple>();
        Set classes = this._kb.getAllClasses();
        for (ATermAppl c : classes) {
            Set comp;
            Set disj;
            Iterator i;
            Node o;
            Set eqs;
            Node p;
            triples.clear();
            Node s = JenaUtils.makeGraphNode(c);
            this.addTriple(triples, s, RDF.type.asNode(), OWL.Class.asNode());
            if (subs) {
                p = RDFS.subClassOf.asNode();
                if (allSubs) {
                    eqs = this._kb.getAllEquivalentClasses(c);
                    for (ATermAppl eq : eqs) {
                        o = JenaUtils.makeGraphNode(eq);
                        this.addTriple(triples, s, p, o);
                    }
                }
                Set supers = allSubs ? this._kb.getSuperClasses(c, false) : this._kb.getSuperClasses(c, true);
                i = IteratorUtils.flatten(supers.iterator());
                while (i.hasNext()) {
                    Node o2 = JenaUtils.makeGraphNode((ATermAppl)i.next());
                    this.addTriple(triples, s, p, o2);
                }
                if (jenaDirectSubs) {
                    p = ReasonerVocabulary.directSubClassOf.asNode();
                    Set direct = allSubs ? this._kb.getSuperClasses(c, true) : supers;
                    i = IteratorUtils.flatten(direct.iterator());
                    while (i.hasNext()) {
                        o = JenaUtils.makeGraphNode((ATermAppl)i.next());
                        this.addTriple(triples, s, p, o);
                    }
                }
            }
            if (equivs) {
                p = OWL.equivalentClass.asNode();
                eqs = this._kb.getAllEquivalentClasses(c);
                for (ATermAppl a : eqs) {
                    o = JenaUtils.makeGraphNode(a);
                    this.addTriple(triples, s, p, o);
                }
            }
            if (disjs && !(disj = this._kb.getDisjointClasses(c)).isEmpty()) {
                p = OWL.disjointWith.asNode();
                i = IteratorUtils.flatten(disj.iterator());
                while (i.hasNext()) {
                    ATermAppl a = (ATermAppl)i.next();
                    if (!classes.contains(a)) continue;
                    this.addTriple(triples, s, p, JenaUtils.makeGraphNode(a));
                }
            }
            if (comps && !(comp = this._kb.getComplements(c)).isEmpty()) {
                p = OWL.complementOf.asNode();
                for (ATermAppl a : comp) {
                    if (!classes.contains(a)) continue;
                    this.addTriple(triples, s, p, JenaUtils.makeGraphNode(a));
                }
            }
            for (Triple t : triples) {
                model.getGraph().add(t);
            }
        }
        return model;
    }

    public Model extractIndividualModel() {
        return this.extractIndividualModel(ModelFactory.createDefaultModel());
    }

    public Model extractIndividualModel(Model model) {
        boolean allClasses = this._selector.contains((Object)StatementType.ALL_INSTANCE);
        boolean jenaDirectClasses = this._selector.contains((Object)StatementType.JENA_DIRECT_INSTANCE);
        boolean classes = allClasses || jenaDirectClasses || this._selector.contains((Object)StatementType.DIRECT_INSTANCE);
        boolean sames = this._selector.contains((Object)StatementType.SAME_AS);
        boolean diffs = this._selector.contains((Object)StatementType.DIFFERENT_FROM);
        boolean objValues = this._selector.contains((Object)StatementType.OBJECT_PROPERTY_VALUE);
        boolean dataValues = this._selector.contains((Object)StatementType.DATA_PROPERTY_VALUE);
        if (classes) {
            this._kb.realize();
        }
        ArrayList<Triple> triples = new ArrayList<Triple>();
        for (ATermAppl ind : this._kb.getIndividuals()) {
            Node p;
            triples.clear();
            Node s = JenaUtils.makeGraphNode(ind);
            if (classes) {
                p = RDF.type.asNode();
                Set types = this._kb.getTypes(ind, !allClasses);
                Iterator i = IteratorUtils.flatten(types.iterator());
                while (i.hasNext()) {
                    Node o = JenaUtils.makeGraphNode((ATermAppl)i.next());
                    this.addTriple(triples, s, p, o);
                }
                if (jenaDirectClasses) {
                    p = ReasonerVocabulary.directRDFType.asNode();
                    Set directTypes = allClasses ? this._kb.getTypes(ind, true) : types;
                    i = IteratorUtils.flatten(directTypes.iterator());
                    while (i.hasNext()) {
                        Node o = JenaUtils.makeGraphNode((ATermAppl)i.next());
                        this.addTriple(triples, s, p, o);
                    }
                }
            }
            if (sames) {
                p = OWL.sameAs.asNode();
                this.addTriple(triples, s, p, s);
                for (ATermAppl a : this._kb.getSames(ind)) {
                    this.addTriple(triples, s, p, JenaUtils.makeGraphNode(a));
                }
            }
            if (diffs) {
                p = OWL.differentFrom.asNode();
                for (ATermAppl a : this._kb.getDifferents(ind)) {
                    this.addTriple(triples, s, p, JenaUtils.makeGraphNode(a));
                }
            }
            if (dataValues || objValues) {
                for (Role role : this._kb.getRBox().getRoles().values()) {
                    List values;
                    if (role.isAnon()) continue;
                    ATermAppl name = role.getName();
                    if (role.isDatatypeRole()) {
                        if (!dataValues) continue;
                        values = this._kb.getDataPropertyValues(name, ind);
                    } else {
                        if (!role.isObjectRole() || !objValues) continue;
                        values = this._kb.getObjectPropertyValues(name, ind);
                    }
                    if (values.isEmpty()) continue;
                    p = JenaUtils.makeGraphNode(name);
                    for (ATermAppl value : values) {
                        this.addTriple(triples, s, p, JenaUtils.makeGraphNode(value));
                    }
                }
            }
            for (Triple t : triples) {
                model.getGraph().add(t);
            }
        }
        return model;
    }

    public Model extractModel() {
        return this.extractModel(ModelFactory.createDefaultModel());
    }

    public Model extractModel(Model model) {
        this.extractClassModel(model);
        this.extractPropertyModel(model);
        this.extractIndividualModel(model);
        return model;
    }

    public Model extractPropertyModel() {
        return this.extractPropertyModel(ModelFactory.createDefaultModel());
    }

    public Model extractPropertyModel(Model model) {
        boolean allSubs = this._selector.contains((Object)StatementType.ALL_SUBPROPERTY);
        boolean jenaDirectSubs = this._selector.contains((Object)StatementType.JENA_DIRECT_SUBPROPERTY);
        boolean subs = allSubs || jenaDirectSubs || this._selector.contains((Object)StatementType.DIRECT_SUBPROPERTY);
        boolean equivs = this._selector.contains((Object)StatementType.EQUIVALENT_PROPERTY);
        boolean invs = this._selector.contains((Object)StatementType.INVERSE_PROPERTY);
        boolean disjs = this._selector.contains((Object)StatementType.DISJOINT_PROPERTY);
        this._kb.prepare();
        ArrayList<Triple> triples = new ArrayList<Triple>();
        for (Role role : this._kb.getRBox().getRoles().values()) {
            Iterator i;
            Set disjoints;
            Set inverses;
            Node o;
            triples.clear();
            if (role.isAnon()) continue;
            ATermAppl name = role.getName();
            Node s = JenaUtils.makeGraphNode(name);
            Node p = RDF.type.asNode();
            if (role.isDatatypeRole()) {
                this.addTriple(triples, s, p, OWL.DatatypeProperty.asNode());
            } else {
                if (!role.isObjectRole()) continue;
                this.addTriple(triples, s, p, OWL.ObjectProperty.asNode());
            }
            if (role.isFunctional()) {
                this.addTriple(triples, s, p, OWL.FunctionalProperty.asNode());
            }
            if (role.isInverseFunctional()) {
                this.addTriple(triples, s, p, OWL.InverseFunctionalProperty.asNode());
            }
            if (role.isTransitive()) {
                this.addTriple(triples, s, p, OWL.TransitiveProperty.asNode());
            }
            if (role.isSymmetric()) {
                this.addTriple(triples, s, p, OWL.SymmetricProperty.asNode());
            }
            if (equivs) {
                p = OWL.equivalentProperty.asNode();
                for (ATermAppl eq : this._kb.getAllEquivalentProperties(name)) {
                    o = JenaUtils.makeGraphNode(eq);
                    this.addTriple(triples, s, p, o);
                    if (!allSubs) continue;
                    this.addTriple(triples, s, RDFS.subPropertyOf.asNode(), o);
                }
            }
            if (invs && !(inverses = this._kb.getInverses((ATerm)name)).isEmpty()) {
                p = OWL.inverseOf.asNode();
                for (ATermAppl inverse : inverses) {
                    this.addTriple(triples, s, p, JenaUtils.makeGraphNode(inverse));
                }
            }
            if (disjs && !(disjoints = this._kb.getDisjointProperties(name)).isEmpty()) {
                p = OWL2.propertyDisjointWith.asNode();
                i = IteratorUtils.flatten(disjoints.iterator());
                while (i.hasNext()) {
                    o = JenaUtils.makeGraphNode((ATermAppl)i.next());
                    this.addTriple(triples, s, p, o);
                }
            }
            if (subs) {
                Set supers;
                Node o2;
                p = RDFS.subPropertyOf.asNode();
                if (allSubs) {
                    Set eqs = this._kb.getAllEquivalentProperties(name);
                    for (ATermAppl eq : eqs) {
                        o2 = JenaUtils.makeGraphNode(eq);
                        this.addTriple(triples, s, p, o2);
                    }
                }
                if (!(supers = this._kb.getSuperProperties(name, !allSubs)).isEmpty()) {
                    i = IteratorUtils.flatten(supers.iterator());
                    while (i.hasNext()) {
                        o = JenaUtils.makeGraphNode((ATermAppl)i.next());
                        this.addTriple(triples, s, p, o);
                    }
                    if (jenaDirectSubs) {
                        p = ReasonerVocabulary.directSubPropertyOf.asNode();
                        Set direct = allSubs ? this._kb.getSuperProperties(name, true) : supers;
                        i = IteratorUtils.flatten(direct.iterator());
                        while (i.hasNext()) {
                            o2 = JenaUtils.makeGraphNode((ATermAppl)i.next());
                            this.addTriple(triples, s, p, o2);
                        }
                    }
                }
            }
            for (Triple t : triples) {
                model.getGraph().add(t);
            }
        }
        return model;
    }

    public EnumSet<StatementType> getSelector() {
        return this._selector;
    }

    public void setSelector(EnumSet<StatementType> selector) {
        this._selector = selector;
    }

    public KnowledgeBase getKB() {
        return this._kb;
    }

    public void setKB(KnowledgeBase kb) {
        this._kb = kb;
    }

    public Predicate<Triple> getFilter() {
        return this._filter;
    }

    public void setFilter(Predicate<Triple> filter) {
        if (filter == null) {
            throw new NullPointerException("Filter cannot be null");
        }
        this._filter = filter;
    }

    public static enum StatementType {
        ALL_INSTANCE,
        ALL_SUBCLASS,
        ALL_SUBPROPERTY,
        COMPLEMENT_CLASS,
        DATA_PROPERTY_VALUE,
        DIFFERENT_FROM,
        DIRECT_INSTANCE,
        DIRECT_SUBCLASS,
        DIRECT_SUBPROPERTY,
        DISJOINT_CLASS,
        DISJOINT_PROPERTY,
        EQUIVALENT_CLASS,
        EQUIVALENT_PROPERTY,
        INVERSE_PROPERTY,
        JENA_DIRECT_INSTANCE,
        JENA_DIRECT_SUBCLASS,
        JENA_DIRECT_SUBPROPERTY,
        OBJECT_PROPERTY_VALUE,
        SAME_AS;

        public static final EnumSet<StatementType> ALL_CLASS_STATEMENTS;
        public static final EnumSet<StatementType> ALL_INDIVIDUAL_STATEMENTS;
        public static final EnumSet<StatementType> ALL_PROPERTY_STATEMENTS;
        public static final EnumSet<StatementType> ALL_STATEMENTS;
        public static final EnumSet<StatementType> ALL_STATEMENTS_INCLUDING_JENA;
        public static final EnumSet<StatementType> PROPERTY_VALUE;
        public static final EnumSet<StatementType> DEFAULT_STATEMENTS;

        static {
            ALL_CLASS_STATEMENTS = EnumSet.of(ALL_SUBCLASS, COMPLEMENT_CLASS, DIRECT_SUBCLASS, DISJOINT_CLASS, EQUIVALENT_CLASS);
            ALL_INDIVIDUAL_STATEMENTS = EnumSet.of(ALL_INSTANCE, new StatementType[]{DATA_PROPERTY_VALUE, DIFFERENT_FROM, DIRECT_INSTANCE, OBJECT_PROPERTY_VALUE, SAME_AS});
            ALL_PROPERTY_STATEMENTS = EnumSet.of(ALL_SUBPROPERTY, DIRECT_SUBPROPERTY, EQUIVALENT_PROPERTY, INVERSE_PROPERTY, DISJOINT_PROPERTY);
            ALL_STATEMENTS = EnumSet.complementOf(EnumSet.of(JENA_DIRECT_INSTANCE, JENA_DIRECT_SUBCLASS, JENA_DIRECT_SUBPROPERTY));
            ALL_STATEMENTS_INCLUDING_JENA = EnumSet.allOf(StatementType.class);
            DEFAULT_STATEMENTS = EnumSet.of(DIRECT_SUBCLASS, new StatementType[]{EQUIVALENT_CLASS, DIRECT_INSTANCE, OBJECT_PROPERTY_VALUE, DATA_PROPERTY_VALUE, DIRECT_SUBPROPERTY, EQUIVALENT_PROPERTY, INVERSE_PROPERTY});
            PROPERTY_VALUE = EnumSet.of(DATA_PROPERTY_VALUE, OBJECT_PROPERTY_VALUE);
        }
    }
}

